/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief SystemSet Listener-Interface- Introduced in MFD Nav
*
* Important:
* Listeners run in the applications body thread when a message arrives, so don't
* block for a long time and delegate longer running calculations to worker threads.
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 add documentation, scenarios, component reaction...
*//****************************************************************************/
#ifndef DIAGLIB_SYSTEMSET_LISTENER_H
#define DIAGLIB_SYSTEMSET_LISTENER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ENUMERATIONS__
#include "Enumerations.h"
#endif

namespace diaglib {

/**************************************************************************//**
* \brief Listener interface for incoming IO control requests
*
* Listener interface that is used to handle SystemSet message events. Derive
* from this interface and implement the event handler according to your needs.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclSystemSetListenerIF
{
public:
   /***********************************************************************//**
   * \brief Incoming SystemSet event handler
   *
   * Is called on incoming SystemSet requests. Components reaction
   * should be one of the following:
   *
   * \param[in]      u32SystemSetID SystemSet ID of the incoming request
   * \param[in]      u32SystemSetType The type of system set that is requested
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnSystemSet (
                               tU32 u32SystemSetID,
                               tenSystemSetType u32SystemSetType,
                               tContext MsgContext
                             ) = 0;

   /***********************************************************************//**
   * \brief Incoming SystemSetFinished handler
   *
   * Is called on incoming SystemSetFinished requests. Components reaction
   * should be one of the following:
   *
   * \param[in]      u32SystemSetID SystemSet ID of the incoming request
   * \param[in]      u32SystemSetType The type of system set that has ended
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnSystemSetFinished (
                                       tU32 u32SystemSetID,
                                       tenSystemSetType u32SystemSetType,
                                       tContext MsgContext
                                     ) = 0;

   /***********************************************************************//**
   * \brief Incoming SystemSet preperation handler
   *
   * Is called on incoming SystemSetPrepare requests. Components reaction
   * should be one of the following:
   *
   * \param[in]      u32SystemSetID SystemSet ID of the incoming request
   * \param[in]      u32SystemSetType The type of system set that should be
   *                 prepared
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnSystemSetPrepare (
                                       tU32 u32SystemSetID,
                                       tenSystemSetType u32SystemSetType,
                                       tContext MsgContext
                                    ) = 0;

   /***********************************************************************//**
   * \brief Incoming SystemSet check handler
   *
   * Is called on incoming Check SystemSet Request.
   *
   * \param[in]      u32SystemSetID SystemSet ID of the incoming request
   * \param[in]      u32SystemSetType The type of system set that should be
   *                 prepared
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   *//*************************************************************************/
   virtual tU32 vOnSystemSetCheck (
                                    tU32 u32SystemSetID,
                                    tenSystemSetType u32SystemSetType,
                                    tContext MsgContext
                                   )
    {
        // Please implement in Concrete Listener
        DIA_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
        DIA_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );
        DIA_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
        NORMAL_M_ASSERT_ALWAYS();
        return U32_DIAGLIB_RETURN_NOT_OK;
    }

   virtual ~tclSystemSetListenerIF() {}
};

}
#endif // DIAGLIB_SYSTEMSET_IF_H


