/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief SystemSet Listener-Interface- Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 add documentation, scenarios, component reaction...
*//****************************************************************************/
#ifndef DIAGLIB_SYSTEMSET_DEFAULT_LISTENER_H
#define DIAGLIB_SYSTEMSET_DEFAULT_LISTENER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#include "Enumerations.h"           //lint !e537 Info 537 , eliminating lint warnings Repeated include file
#include "tclSystemSetListenerIF.h" //lint !e537 Info 537 , eliminating lint warnings Repeated include file


namespace diaglib {

class tclSystemSetIF; //lint !e763

/**************************************************************************//**
* \brief Default Listener for incoming system set requests
*
* Default Listener that can be used to handle SystemSet messages. Use an
* an instance of this class as a listener, if you don't have anything to do on
* a SystemSet request. This default implementation just returns SUCCESS back to
* diagnosis.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclSystemSetDefaultListener: public tclSystemSetListenerIF
{
public:
   tclSystemSetDefaultListener(tclSystemSetIF* poIF);
   virtual ~tclSystemSetDefaultListener();

   virtual tU32 vOnSystemSet (
                               tU32 u32SystemSetID,
                               tenSystemSetType u32SystemSetType,
                               tContext MsgContext
                             );

   virtual tU32 vOnSystemSetFinished (
                                       tU32 u32SystemSetID,
                                       tenSystemSetType u32SystemSetType,
                                       tContext MsgContext
                                     );

   virtual tU32 vOnSystemSetPrepare (
                                       tU32 u32SystemSetID,
                                       tenSystemSetType u32SystemSetType,
                                       tContext MsgContext
                                    );

   virtual tU32 vOnSystemSetCheck (
                                    tU32 u32SystemSetID,
                                    tenSystemSetType u32SystemSetType,
                                    tContext MsgContext
                                   );

 private:
    tclSystemSetDefaultListener();//lint !e1704 Info 1704 , eliminating lint warnings
    tclSystemSetIF* poSysSetIF;
};

}
#endif // DIAGLIB_SYSTEMSET_DEFAULT_LISTENER_H


