/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Service Handler - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_SERVICE_HANDLER_H
#define DIAGLIB_SERVICE_HANDLER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#include "tclMessageContext.h"
#include "tclMessageContextManager.h"
#include "Enumerations.h"




namespace diaglib {

class tclSystemSetListenerIF;
class tclDiagnosisDataListenerIF;
class tclRoutineControlListenerIF;
class tclIoControlListenerIF;

/**
 * Abstract base class for a service handler. Independent of the concrete protocol
 * used
 */
class tclServiceHandler
{

public:
   /**
    * Public functions to send responses
    */
   virtual ~tclServiceHandler() {}

   virtual tBool bSendSystemSetMethodResult (
                                              tenSystemSetResult,
                                              const tclParameterVector&,
                                              tContext context
                                            ) = 0;

   virtual tBool bSendSystemSetPrepareMethodResult (
                                                     tenSystemSetResult,
                                                     const tclParameterVector&,
                                                     tContext context
                                                   ) = 0;

   virtual tBool bSendSystemSetFinishedMethodResult (
                                                      tContext context
                                                    ) = 0;

   virtual tBool bSendSystemSetCheckResult (
                                             tenSystemSetResult enSystemSetResult,
                                             const tclParameterVector& oValueList,
                                             tContext MsgContext
                                           ) = 0;

   virtual tBool bSendDiagnosisDataResult (
                                                  tenDiagDataResult enReadResult,
                                                  const tclParameterVector& oReadValues,
                                                  tContext context
                                                ) = 0;


   virtual tBool bSendIoCtrlMethodResult (
                                              tenIoCtrlResult enIoResult,
                                              tenIoControlAction enAction,
                                              const tclParameterVector& oResultList,
                                              tContext context
                                            ) = 0;

   virtual tBool bSendIoCtrlFreezeResult (
                                              tenIoCtrlResult enIoResult,
                                              tContext context
                                            ) = 0;

   virtual tBool bSendIoCtrlUnfreezeResult (
                                              tenIoCtrlResult enIoResult,
                                              tContext context
                                            ) = 0;

   virtual tBool bSendRoutineCtrlMethodResult (
                                                tenRoutineCtrlResult enRoutineStatus,
                                                const tclParameterVector& oRoutineResult,
                                                tContext context
                                              ) = 0;

   virtual tBool bSendGetRoutineResultMethodResult (
                                                     tenRoutineCtrlResult enRoutineStatus,
                                                     const tclParameterVector& oRoutineResult,
                                                     tContext context
                                                   ) = 0;

   /**
    * Listener registration functions
    */

   virtual tVoid vRegisterSystemSetListener      (
                                                   tclSystemSetListenerIF* poListener
                                                 ) = 0;

   virtual tVoid vRegisterDiagDataListener       (
                                                   tclDiagnosisDataListenerIF* poListener
                                                 ) = 0;

   virtual tVoid vRegisterRoutineControlListener (
                                                   tclRoutineControlListenerIF* poListener
                                                 ) = 0;

   virtual tVoid vRegisterIoControlListener      (
                                                   tclIoControlListenerIF* poListener
                                                 ) = 0;

   virtual tVoid vRegisterDiagnosisDataListener  (
                                                   tclDiagnosisDataListenerIF* poListener
                                                 ) = 0;

   virtual tU32 u32GetAppIdentifier() = 0;
};
}
#endif // DIAGLIB_SERVICE_HANDLER_H


