/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Message context manager - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_MESSAGE_CONTEXT_MANAGER_H
#define DIAGLIB_MESSAGE_CONTEXT_MANAGER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#include <map>
#include <set>
using std::map;
using std::set;

#include "Enumerations.h"
#include "tclMessageContext.h"
#include "tclLock.h"

#define DIAGLIB_EVENT_NAME   "DlibEv"
// Event for Timer trigger
#define DIAGLIB_EVENT_TIMER         0x00000001
// Event to kill the worker thread
#define DIAGLIB_EVENT_KILL_THREAD   0x00000002

// OR combination of all events relevant for worker thread
#define DIAGLIB_WORKER_EVENT_MASK   (DIAGLIB_EVENT_TIMER | DIAGLIB_EVENT_KILL_THREAD)




namespace diaglib {

/***********************************************************************//**
 * \brief Message Context manager
 *
 * The MessageContextManager does what the name implies. There is one
 * MessageContextManager for all components. Access to the internal
 * container is secured using a seamphore that only allows one thread
 * at a time. The stored contexts are under timeout supervision using a
 * timer and a worker thread.
 *//************************************************************************/
class tclMessageContextManager
{
private:
   static map<tU32, tclMessageContext*>   oContextMap;
   static tclLock                         mLock;
   static tU16                            u16UserCount;

   static tU32                            u32StaticCounter;
   static OSAL_tTimerHandle               hStaticTimeoutTimer;
   static OSAL_tSemHandle                 StaticSemHandle;
   static tBool                           bStaticTimerActive;
   static tU16                            u16StaticCtxtPeriod;
   static OSAL_tThreadID                  s32StaticThreadId;
   static OSAL_tEventHandle               s32StaticEventHdl;

   static tVoid spawnTimeoutThread();
   static tVoid killTimeoutThread();
   static tVoid vFillThreadAttributes(OSAL_trThreadAttribute& attrib);
   static tVoid vTimeoutWorkerThread(tVoid* pDontCare);
   static tVoid vHandleThreadOnSecPassed();
   static tVoid vHandlerAllContextsOnSecPassed();

   static tclMessageContext* bGetContextBack(tU32 u32Handle);
public:

   static OSAL_tpfCallback vOnSecondsPassed(const tVoid* poThis);

   static tVoid vIncreaseUsers();
   static tVoid vDecreaseUsers();
   static tU32 poAddContext(tclMessageContext* poMsgContext);

   template<typename T>
   static tBool bGetContextBack(tU32 u32Handle, T** ppContext);
};

template<typename T>
tBool tclMessageContextManager::bGetContextBack(tU32 u32Handle, T** ppContext)
{
   *ppContext = OSAL_NULL;
   *ppContext = static_cast<T*>(tclMessageContextManager::bGetContextBack(u32Handle));
   if(*ppContext == OSAL_NULL)
   {
      return FALSE;
   }
   else
   {
      return TRUE;
   }
}

}
#endif // DIAGLIB_MESSAGE_CONTEXT_MANAGER_H


