/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Message context - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_MESSAGE_CONTEXT_H
#define DIAGLIB_MESSAGE_CONTEXT_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#include "Enumerations.h"

namespace diaglib {

#define DIAGLIB_MESSAGE_CONTEXT_TIMEOUT_SEC 15
#define DIAGLIB_MESSAGE_CONTEXT_TIMEOUT_SEC_SYSTEM_SET 75

/***********************************************************************//**
 * \brief Message Context base class
 *
 * The MessageContext has been introduced to map the components response
 * unambiguously to its associated request. For each incoming message from
 * fc_diagnosis a Messagecontext is created, depending on the protocol used
 * additional information in a sublass might be introduced. This
 * MessageContext is stored in a MessageContextManager. The component this
 * request was addressed to, receives a Context indentifier camouflaged as a
 * void pointer. When the component sends a response to this message it has
 * to deliver the correct void pointer, so the Manager can retrieve the
 * correct context. The Context is used to compose the outgoing message and
 * is deleted after the message was sent. This has some consequences:
 * /li Only one response to a request is possible. If the component tries to
 * send a second  response using the same void pointer twice, a error is
 * returned to the component.
 * /li If the component does not respond at all the context would stay on the
 * heap and would waste memory.
 *
 * For the second consequence, which of course is unwanted a timer was
 * introduced. A timeout value is attached to each context. This value gets
 * decremented by a defined value every time the timer callback is called.
 * For debugging and testing convenience the timeout value and the value that
 * gets subtracted on a callback represent seconds. Both the timeout value,
 * and the timer frequency are variable and can be defined. For example
 * a message context could time out after 15 seconds. The timer might call
 * back every 5 seconds. So every 5 seconds, the timer callback decrements the
 * timeout value of each context by 5. If a timeout value reaches zero, the
 * context timed out and is released.
 *
 * If a component tries to send a response, after the connected context timed
 * out, an error return code is issued to the component.
 *
 * 25.08.2008
 * Adding timing functionality. When activated using the feature-switch this
 * traces out the time a message took until it was responded to.
 * Feature switch: VARIANT_S_FTR_ENABLE_FEAT_DIAGLIB_MSG_TIMING
 *
 *//************************************************************************/
class tclMessageContext
{
public:
   enum ten_MessageGroup
   {
      EN_MESSAGE_ROUTINE_CONTROL,
      EN_MESSAGE_IO_CONTROL,
      EN_MESSAGE_DIAG_DATA,
      EN_MESSAGE_SYSTEM_SET
   };

   tclMessageContext(ten_MessageGroup enGroup, tU32 u32Id, tU32 u32AdditionalValue = 0);
   virtual ~tclMessageContext();

   ten_MessageGroup getMessageGroup() const;

   tU32 getId() const;
   virtual tBool getSystemSetType(tenSystemSetType& enType) const;
   virtual tBool getIoControlAction(tenIoControlAction& enAction) const;

   virtual tVoid vResestTimeout(ten_MessageGroup enGroup);
   virtual tVoid vSecondsPassed(tU16 u16Seconds);
   virtual tBool bDidContextTimeout() const;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_DIAGLIB_MSG_TIMING
   virtual tU32  u32GetCreationTick();
#endif

protected:
   tclMessageContext():
         u32SecondsToTimeout(0),
         enMessageGroup(EN_MESSAGE_SYSTEM_SET),
         enSystemSetType(EN_TYPE_DEFAULT_HMI),
         enIoControlAction(EN_ACTION_SET),
         u32UniqueId(0),
         bValid(true) {}
   tU32 u32SecondsToTimeout;
   ten_MessageGroup enMessageGroup;

   tenSystemSetType enSystemSetType;
   tenIoControlAction enIoControlAction;
   tU32 u32UniqueId;
   tBool bValid;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_DIAGLIB_MSG_TIMING
   OSAL_tMSecond u32CreationTick;
#endif
};
}
#endif // DIAGLIB_MESSAGE_CONTEXT_H

