

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif
#include "tclLock.h"

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_SERVICE_DIAGLIB
#include "Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_GENERAL
#include "trcGenProj/Header/tclLock.cpp.trc.h"
#endif

//------------------------------------------------------------------------------

namespace diaglib {

   tclLock::tclLock (tCString name, eLockState mode)
      : mName(name),
      mHandle(OSAL_C_INVALID_HANDLE)
   {
      char acIdName[10] = "";
      sprintf(acIdName,"%lx",(long int)OSAL_ProcessWhoAmI());
      //ETG_TRACE_COMP_THR(( "--- tclLock::tclLock => Name: %s",acIdName));

      mName += acIdName;
      //mName += (static_cast<tChar>(OSAL_ProcessWhoAmI())+0x30);
      ETG_TRACE_COMP_THR(( "--- tclLock::tclLock => Name: %s",mName.c_str()));

      //et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib tclLock create: %s",mName.c_str());

      tS32 s32Result = OSAL_s32SemaphoreCreate( mName.c_str(), &mHandle, (mode == eUnlocked) ? 1 : 0 );
      if(OSAL_OK != s32Result)
      {
         tU32 u32ErrorCode= OSAL_u32ErrorCode();
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib tclLock::tclLock => OSAL_s32SemaphoreCreate failed: Result=%x, Error=%x",
                                  s32Result,
                                  u32ErrorCode);
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib tclLock::tclLock => SemName: %s",mName.c_str());
         NORMAL_M_ASSERT_ALWAYS();
      }
   }

   //------------------------------------------------------------------------------

   tclLock::~tclLock ( tVoid )
   {
      _BP_TRY_BEGIN
      {
         if( OSAL_C_INVALID_HANDLE != mHandle )
         {
            tS32 s32Result = OSAL_s32SemaphoreClose(mHandle);
            if(OSAL_OK != s32Result)
            {
               tU32 u32ErrorCode= OSAL_u32ErrorCode();
               et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib OSAL_s32SemaphoreClose failed: Result=%x, Error=%x",
                                        s32Result,
                                        u32ErrorCode);
               NORMAL_M_ASSERT_ALWAYS();
            }
            s32Result = OSAL_s32SemaphoreDelete(mName.c_str());
            if(OSAL_OK != s32Result)
            {
               tU32 u32ErrorCode= OSAL_u32ErrorCode();
               et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib OSAL_s32SemaphoreDelete failed: Result=%x, Error=%x",
                                        s32Result,
                                        u32ErrorCode);
               NORMAL_M_ASSERT_ALWAYS();
            }
         }
      }
      _BP_CATCH_ALL
      {

      }
      _BP_CATCH_END
   }

   //------------------------------------------------------------------------------

   tBool
      tclLock::bUnlock ( tVoid )
   {
      NORMAL_M_ASSERT( OSAL_C_INVALID_HANDLE != mHandle );
      tS32 s32Result = OSAL_s32SemaphorePost( mHandle );
      if(OSAL_OK != s32Result)
      {
         tU32 u32ErrorCode= OSAL_u32ErrorCode();
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib OSAL_s32SemaphorePost failed: Result=%x, Error=%x",
                                  s32Result,
                                  u32ErrorCode);
         NORMAL_M_ASSERT_ALWAYS();
      }
      return ( OSAL_OK == s32Result );
   }

   //------------------------------------------------------------------------------

   tS32
      tclLock::s32Lock ( tU32 timeout )
   {
      NORMAL_M_ASSERT( OSAL_C_INVALID_HANDLE != mHandle );
      tS32 s32Result = OSAL_s32SemaphoreWait( mHandle, timeout );
      if(OSAL_OK != s32Result)
      {
         tU32 u32ErrorCode= OSAL_u32ErrorCode();
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "Diaglib OSAL_s32SemaphoreWait failed: Result=%x, Error=%x",
                                  s32Result,
                                  u32ErrorCode);
         NORMAL_M_ASSERT_ALWAYS();
      }
      return s32Result;
   }

}
