/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Io Control Listener-Interface- Introduced in MFD Nav
*
* Important:
* Listeners run in the applications body thread when a message arrives, so don't
* block for a long time and delegate longer running calculations to worker threads.
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 Add documentation, scenarios, component reaction...
*//****************************************************************************/
#ifndef DIAGLIB_IO_CONTROL_LISTENER_H
#define DIAGLIB_IO_CONTROL_LISTENER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ENUMERATIONS__
#include "Enumerations.h"
#endif

namespace diaglib {


/**************************************************************************//**
* \brief Listener interface for incoming IO control requests
*
* Listener interface that is used to handle IO control message events. Derive
* from this interface and implement the event handler according to your needs.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclIoControlListenerIF
{
public:
   /***********************************************************************//**
   * \brief Incoming IO-control event handler
   *
   * Is called on incoming IO control requests. Components reaction
   * should be one of the following:
   *
   * \param[in]      u32IoControlId IO control ID of the incoming request
   * \param[in]      enActionId The requested action in this IO control.
   * \param[in]      oParameterVector Parameters for the request as defined in
   *                 ID specification document.
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               tenIoControlAction enActionId,
                               const tclParameterVector& oParameterVector,
                               tContext MsgContext
                             ) = 0;


   /***********************************************************************//**
   * \brief Incoming IO-control freeze request handler
   *
   * Is called on incoming freeze requests. Components reaction should be one
   * of the following:
   *
   * \param[in]      u32IoControlId IO control ID of the incoming request
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     tContext MsgContext
                                   ) = 0;

   /***********************************************************************//**
   * \brief Incoming IO-control unfreeze request handler
   *
   * Is called on incoming unfreeze requests. Components reaction should be one
   * of the following:
   *
   * \param[in]      u32IoControlId IO control ID of the incoming request
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnIoControlUnfreeze (
                                       tU32 u32IoControlId,
                                       tContext MsgContext
                                     ) = 0;



   virtual ~tclIoControlListenerIF() {}
};
}
#endif // DIAGLIB_IO_CONTROL_LISTENER_H


