/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief IO Control Interface - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
* \Todo 2008-07-10 Add documentation, sequence diagrams ...
* \Todo 2008-07-10 Add send functions for Freeze and Unfreeze responses
*//****************************************************************************/
#ifndef DIAGLIB_IO_CONTROL_IF_H
#define DIAGLIB_IO_CONTROL_IF_H


#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ENUMERATIONS__
#include "Enumerations.h"
#endif

#include "tclDiagnosisIF.h"   //lint !e537 Info 537 , eliminating lint warnings Repeated include file




namespace diaglib {

class tclInterfaceManager; //lint !e763
class tclIoControlListenerIF; //lint !e763

/**************************************************************************//**
* \brief Interface to provide IO control functionality.
*
* Interface to handle IO control requests and send answers to these requests.
* Also use this interface to register your provided IO control service IDs.
* See general documentation for a more detailed description of the concept this
* interface follows.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclIoControlIF : public tclDiagnosisIF
{
protected:
   virtual ~tclIoControlIF() {}



public:
   /***********************************************************************//**
   * \brief Send result of a IO control operation.
   *
   * Sends a response on a IO control request with the provided parameters and
   * the provided message context. See details on messageContext concept in
   * general documentation.
   *
   * \param[in]      enIoResult        The result of this IO control action
   * \param[in]      enActionId The requested action in this IO control.
   * \param[in]      oResultList       Result vesctor or in case of error:
   *                 the cause.
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendIoCtrlMethodResult   (
                                              tenIoCtrlResult enIoResult,
                                              tenIoControlAction enAction,
                                              const tclParameterVector& oResultList,
                                              tContext MsgContext
                                           ) = 0;

   /***********************************************************************//**
   * \brief Send result of a IO control operation.
   *
   * Sends a response on a IO control request with the provided parameters and
   * the provided message context. See details on messageContext concept in
   * general documentation.
   *
   * \param[in]      enIoResult        The result of this IO control action
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendIoCtrlFreezeResult   (
                                              tenIoCtrlResult enIoResult,
                                              tContext MsgContext
                                           ) = 0;

   /***********************************************************************//**
   * \brief Send result of a IO control operation.
   *
   * Sends a response on a IO control request with the provided parameters and
   * the provided message context. See details on messageContext concept in
   * general documentation.
   *
   * \param[in]      enIoResult        The result of this IO control action
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendIoCtrlUnfreezeResult   (
                                                 tenIoCtrlResult enIoResult,
                                                 tContext MsgContext
                                              ) = 0;

   /***********************************************************************//**
   * \brief Send a message with a diaglib error code back to diagnosis
   *
   * Sends a response on a IO control request in case of an internal error
   *
   * \param[in]      enErrorCode       Internal error that occured
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   ) = 0;

   /***********************************************************************//**
   * \brief Register listener that handles incoming messages.
   *
   * Method to register a listener, that is called on every incoming IO control
   * message of the specified ID.
   * IMPORTANT:
   * Listener registration for one component is NOT THREAD SAFE! So components
   * either have to register their listeners in sequence in a single thread
   * or have to secure calls to this functions by a semaphore.
   *
   * \param[in]      u32Id ID the given listener should be called for
   * \param[in]      poIoListener Pointer to listener that is called
   *                 on incoming messages
   *
   * \return         none
   *//*************************************************************************/
   virtual tVoid vRegisterListener ( tU32 u32Id, tclIoControlListenerIF* poIoListener ) = 0;

   static tenDiagHandlerInterfaces mInterfaceUID; //lint !e1516: This is supposed to "override" the similar named variable in the base class
};
#ifdef DIAGLIB_STATIC_IF_DEFINES
tenDiagHandlerInterfaces tclIoControlIF::mInterfaceUID = EN_INTERFACE_IO_CONTROL;
#endif
}
#endif // DIAGLIB_IO_CONTROL_IF_H

