/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Interface Manager - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_INTERFACE_MANAGER_H
#define DIAGLIB_INTERFACE_MANAGER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#include "Enumerations.h"
#include "tclDiagnosisIF.h"

namespace diaglib {

#define DIAGLIB_DELETE_IF_NOT_NULL(var) \
   if(var != OSAL_NULL) \
      OSAL_DELETE var;  \
   var = OSAL_NULL;

// Forward declerations to reduce dependencies
class tclServiceHandler;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAGLIB_CCA
class tclCCAServiceProxy;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAGLIB_CSFW
class tclCSFWServiceProxy;
#endif

class tclRoutineControlHandler;
class tclDiagDataHandler;
class tclIoControlHandler;
class tclSystemSetHandler;
class tclDiagnosisInterfaceFactory;

/**************************************************************************//**
* \brief Manages all interfaces and its implementations for one component.
*
* Interface manager as name says manages the interfaces (and classes that
* implement these interfaces) that belong to a component. By doing this he
* stays in the background and is not visible to the user of this lib. Creation
* of interfaces is delegated to this class, as it is the only entity that has
* the overview over the system.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclInterfaceManager: public tclDiagnosisIF
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(tclInterfaceManager);
private:
   friend class tclDiagnosisInterfaceFactory;

   // Protocol this Interface Manager has to support and create the
   // service handler for.
   tenSupportedProtocols          enProtocol;

   // Internal pointer to all possible interfaces / objects
   tclServiceHandler*             poServiceHandler;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAGLIB_CCA
   tclCCAServiceProxy*            poCCAServiceProxy;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAGLIB_CSFW
   tclCSFWServiceProxy*           poCSFWServiceProxy;
#endif

   tclRoutineControlHandler*      poRoutineControlHandler;
   tclDiagDataHandler*            poDiagDataHandler;
   tclIoControlHandler*           poIoControlHandler;
   tclSystemSetHandler*           poSystemSetHandler;

   // Flag if the internal structure has been deleted
   tBool bDeleted;

   virtual ~tclInterfaceManager();

public:

   tclInterfaceManager ();

   tVoid vInit (
                  tenSupportedProtocols enRequestedProtocol,
                  tVoid* poApplicationContext
               );

   tclDiagnosisIF* poGetMainInterface();

   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId);

   tVoid vDeleteServiceHandlerAndInterfaces();
};
}
#endif // DIAGLIB_TCL_INTERFACE_MANAGER_H


