/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Diagnosis Interface Factory - Diagnosis library - Introduced in MFD Nav
*
* \todo add comments (doxygen)
*
* (c) 2008-2011 Robert Bosch Car Multimedia GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_DIAG_IF_FACTORY

#include "tclDiagnosisInterfaceFactory.h"

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#include "Trace.h"


#include "tclInterfaceManager.h"
#include "tclServiceHandler.h"
#include "tclDiagnosisIF.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_GENERAL
#include "trcGenProj/Header/tclDiagnosisInterfaceFactory.cpp.trc.h"
#endif

/*
 To diaglib developer:
 When changing the version here make sure you change the version in 
 Version.h accordingly.
*/
#define DIAGLIB_U8_MAJOR_VERSION 1
#define DIAGLIB_U8_MINOR_VERSION 0

tU8 diaglib_FuncTrace::mu8InstanceCounter = 0;

namespace diaglib {

/*
For documentation see header file. This is the only class that is not abstracted
by an interface, so doxygen documentation in header focuses on users of this lib.
*/

// Implements singleton pattern. This is the private static reference.
tclDiagnosisInterfaceFactory* tclDiagnosisInterfaceFactory::poInstance = OSAL_NULL;

/*
Constructor
*/
tclDiagnosisInterfaceFactory::tclDiagnosisInterfaceFactory()
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_CONSTRUCTOR);
   // Todo: Sth to be done here?
}

/*
Destructor
*/
tclDiagnosisInterfaceFactory::~tclDiagnosisInterfaceFactory()
{
}

/*
Part of the singelton pattern. static GetInstance function.
Returns singleton instance and creates it, if it did not exist before.
*/
tclDiagnosisInterfaceFactory* tclDiagnosisInterfaceFactory::poGetInstance()
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_GETINSTANCE);

   if(OSAL_NULL == poInstance)

   {
      poInstance = OSAL_NEW tclDiagnosisInterfaceFactory();
   }

   /*
   That's bad. "new" failed.
   */
   if(OSAL_NULL == poInstance)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP);
      FATAL_M_ASSERT_ALWAYS();
   }
      
   

   return poInstance;
}

/*
This is the entry for a component. It will call it once to init its own instance of the diaglib framework.
What we do is create an instance of the InterfaceManager, call init on it, and return a pointer to it.
Job finished.
*/
tclDiagnosisIF* tclDiagnosisInterfaceFactory::poCreateDiagnosisInterface(tenSupportedProtocols enProtocol, tVoid* poApplicationContext) const
{
   tclInterfaceManager* poManager;

   diaglib_FuncTrace oTrace(I_DIAGLIB_F_CREATEDIAGNOSISINTERFACE);

   if(OSAL_NULL == poApplicationContext)
   {
      ETG_TRACE_USR2_THR(( "!!! tclDiagnosisInterfaceFactory::poCreateDiagnosisInterface => ERROR: OSAL_NULL == poApplicationContext"));
      //DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }

   tclMessageContextManager::vIncreaseUsers();
   // This Interface Manage object is responsible exclusively for the calling component, it is the manager for
   // all other objects that are created for this framework-instance.
   poManager = OSAL_NEW tclInterfaceManager();

   if(OSAL_NULL == poManager)
   {
      /*
      new failed
      */
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP);
      FATAL_M_ASSERT_ALWAYS();
   }
   else
   {
      poManager->vInit(enProtocol, poApplicationContext);
   }

   

   return poManager;
}

/*
Component wants to deinitialize its own diaglib framework instance. In order for us to figure out
what Manages is the one to be destoried, we use the provided pointer, which is ONE of multiple we
may have issued to the component. We want to get the main interface using this pointer, and as
we know, the main interface is implemented by the InterfaceManager only, so we can dynamic_cast it.
Everything else that needs to be done we delegate to the InterfaceManager. When it is done, we free
the manager itself, and everything is tidy again.
*/
tBool tclDiagnosisInterfaceFactory::bDeleteConnectionAndFreeInterfaces(tclDiagnosisIF* poInterface) const
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_DELCONNANDFREEIF);

   if(OSAL_NULL == poInterface)
   {
      ETG_TRACE_ERR_THR(( "!!! tclDiagnosisInterfaceFactory::bDeleteConnectionAndFreeInterfaces => ERROR: OSAL_NULL == poInterface "));
      //DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return false;
   }

   // In order to free the whole framework-instance we need to go through its interface manager.
   // As the Interface Manager implements the DiagnosisIF, we retrieve this and dynamic_cast it
   // to an InterfaceManager. 
   tclDiagnosisIF*       poMainInterface = poInterface->poGetInterface(EN_INTERFACE_DIAGNOSIS);
   tclInterfaceManager*  poManager = static_cast<tclInterfaceManager*> (poMainInterface); //lint !e1774 Info: could use dynamic_cast to downcast polymorphic type; But we compile with --nortti option

   if(OSAL_NULL != poManager)
   {
      tclMessageContextManager::vDecreaseUsers();
      // When we got this, we call the function to free everything.
      poManager->vDeleteServiceHandlerAndInterfaces();

      // And afterwards we free the manager itself.
      OSAL_DELETE poManager;
   }
   else
   {
      ETG_TRACE_ERR_THR(( "!!! tclDiagnosisInterfaceFactory::bDeleteConnectionAndFreeInterfaces => ERROR: OSAL_NULL == poManager "));
      //DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return false;
   }

   

   return true;
}

/*
Returns the version of the diaglib. Compare the major version with the one you expect and
trace out an error or at least a warning if it differs. So you will be aware of possible 
issues caused by version mismatch.
*/
tBool tclDiagnosisInterfaceFactory::bGetVersion(tU8& u8MajorVersion, tU8& u8MinorVersion) const
{
   u8MajorVersion = DIAGLIB_U8_MAJOR_VERSION;
   u8MinorVersion = DIAGLIB_U8_MINOR_VERSION;

   return TRUE;
}
}
