/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Diagnosis Interface - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 Add more documentation
*//****************************************************************************/

/**
 * \defgroup diaglibAPI
 */
#ifndef DIAGLIB_DIAGNOSIS_IF_H
#define DIAGLIB_DIAGNOSIS_IF_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ENUMERATIONS__
#include "Enumerations.h"
#endif

namespace diaglib {

/**************************************************************************//**
* \brief Basic interface to get additional interfaces.
*
* This interface only provides the basic functionality to retrieve additional
* interfaces.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclDiagnosisIF
{
protected:
   virtual ~tclDiagnosisIF() {}

public:
   /***********************************************************************//**
   * \brief Retrieve an additional interface
   *
   * Creates and returns a reference to the requested interface.
   *
   * \param[in]      enInterfaceId  Identifier of the requested interface type
   *
   * \return         Pointer to the requested interface. Cast to appropriate
   *                 type
   *//*************************************************************************/
   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId) = 0;
   template<typename T> tBool bGetInterface(T** pInterface);

   static tenDiagHandlerInterfaces mInterfaceUID; //lint !e1516: This is supposed to "override" the similar named variable in the base class
};

#ifdef DIAGLIB_STATIC_IF_DEFINES
tenDiagHandlerInterfaces tclDiagnosisIF::mInterfaceUID = EN_INTERFACE_DIAGNOSIS;
#endif

template<typename T> tBool tclDiagnosisIF::bGetInterface(T** pInterface)
{
   *pInterface = OSAL_NULL;

   *pInterface = static_cast<T*>(poGetInterface(T::mInterfaceUID));

   return ((*pInterface) != OSAL_NULL);
}

}
#endif // DIAGLIB_DIAGNOSIS_IF_H



