/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Diagnosis Data Listener-Interface - Diagnosis Library - Introduced in MFD Nav
*
* Important:
* Listeners run in the applications body thread when a message arrives, so don't
* block for a long time and delegate longer running calculations to worker threads.
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 Add more documentation, scenarios, component reaction
*//****************************************************************************/
#ifndef DIAGLIB_DIAGDATA_LISTENER_H
#define DIAGLIB_DIAGDATA_LISTENER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#include "Enumerations.h"

namespace diaglib {

/**************************************************************************//**
* \brief Listener interface for incoming diagnosis data requests
*
* Listener interface that is used to handle diagnosis data message events.
* Derive from this interface and implement the event handler according to your
* needs.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclDiagnosisDataListenerIF
{
public:
   /***********************************************************************//**
   * \brief Incoming diagnosis data event handler
   *
   * Is called on incoming diagnostic write requests. Components reaction
   * should be one of the following:
   *
   * \param[in]      u32DiagDataId Diagnosis data ID of the incoming request
   * \param[in]      oParamVector Parameters as specified in the IDspec
   * \param[in]      poMsgContext Internal message context. Just return exactly
   *                 this context when you answer to this request.
   *
   * \return         tU32 ResultCode, currently not checked. Please return 0.
   * \todo           Insert scenario description and link sequence diagrams
   *//*************************************************************************/
   virtual tU32 vOnDiagnosisDataRead (
                                      tU32 u32DiagDataId,
                                      diaglib::tContext MsgContext
                                      )=0;

   virtual tU32 vOnDiagnosisDataWrite (
                                   tU32 u32DiagDataId,
                                   const diaglib::tclParameterVector& oParamVector,
                                   diaglib::tContext MsgContext
                                   )=0;

   virtual ~tclDiagnosisDataListenerIF() {}

};
}
#endif // DIAGLIB_DIAGDATA_LISTENER_H


