/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief CCA Service Interface - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 Add more documentation.
*//****************************************************************************/
#ifndef DIAGLIB_CCA_SERVICE_IF_H
#define DIAGLIB_CCA_SERVICE_IF_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define  AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"
#endif

#include "tclDiagnosisIF.h"   //lint !e537 Info 537 , eliminating lint warnings Repeated include file

class amt_tclServiceData; //lint !e763

namespace diaglib {

class tclInterfaceManager; //lint !e763
/**************************************************************************//**
* \brief CCA Service Interface
*
* Interface that enables communication directly to the internal CCA service.
* Bend your calls in CCA application to use this interface.
*
* \ingroup        diaglibAPI
* \todo           Test, Review, more detailed documentation
*//****************************************************************************/
class tclCCAServiceIF : public tclDiagnosisIF
{
protected:
   virtual ~tclCCAServiceIF() {}

public:
   /***********************************************************************//**
   * \brief Set application for diaglib to work with
   *
   * \return  void
   *//************************************************************************/
   virtual tVoid vSetApplication(ail_tclIAppAdapt* poApp) = 0;

   /***********************************************************************//**
   * \brief Read ServiceID from CCA service
   *
   * Possibility to retrieve the service ID out of the internal CCA service.
   * Components commonly use this to check if they have to dispatch an incoming
   * message to the library.
   *
   * \return  Service ID of internal CCA service
   *//************************************************************************/
   virtual tU16 u16GetServiceId() = 0;

   /***********************************************************************//**
   * \brief Dispatch and handle provided message
   *
   * A call to this function will dispatch the provided message to the
   * appropriate instance. The library will analyze it and depending on its
   * contents it could be delivered back to the component through a function
   * call on one of the registered listeners. DIAGLIB WON'T DELETE THE MESSAGE
   * SO IT IS THE APPLICATIONS RESPOSIBILITY TO CALL bDelete() ON IT AFTER IT
   * WAS DISPACTHED AND HANDLED BY THE LIB.
   *
   * \param[in] poMessage - CCA message to dispatch
   *
   * \return  none
   *//************************************************************************/
   virtual tVoid vDispatchMessage(amt_tclServiceData* poMessage) = 0;

   /***********************************************************************//**
   * \brief Adjust service to fit new application state
   *
   * This function will take required steps inside the internal CCA service
   * in order to comply with the given new application state.
   *
   * \param[in] u32OldState - The old application state
   * \param[in] u32NewState - The new application state
   *
   * \return  none
   *//************************************************************************/
   virtual tVoid vOnNewAppState(tU32 u32OldState, tU32 u32NewState) = 0;

   /***********************************************************************//**
   * \brief Communicate service state changes of other services
   *
   * The framework uses this method to inform the appliction about a service
   * state change of another server. This can only happen if the application
   * has a client part and is registered with this server. So for the purpose
   * of this diagnosis library this function is only here to complete the
   * interface between application and service.
   *
   * \param[in] u16ServiceId   The SID of the service that changed
   * \param[in] u16ServerId    The AppID of the service that changed
   * \param[in] u16RegisterId  Our registration ID
   * \param[in] u8ServiceState The new service state
   * \param[in] u16SubId       SubId whos service state is sent
   *
   * \return  none
   *//************************************************************************/
   virtual tVoid vOnServiceState (
                                   tU16 u16ServiceId,
                                   tU16 u16ServerId,
                                   tU16 u16RegisterId,
                                   tU8  u8ServiceState,
                                   tU16 u16SubId
                                 ) = 0;

  /***********************************************************************//**
   * \brief
   *
   * \todo COMMENT
   *
   * \param[in]
   *
   * \return  none
   *//************************************************************************/
   virtual tBool bGetServiceVersion ( tU16& rfu16MajorVersion,
                                      tU16& rfu16MinorVersion,
                                      tU16& rfu16PatchVersion) = 0;

   static tenDiagHandlerInterfaces mInterfaceUID; //lint !e1516: This is supposed to "override" the similar named variable in the base class
};

#ifdef DIAGLIB_STATIC_IF_DEFINES
tenDiagHandlerInterfaces tclCCAServiceIF::mInterfaceUID = EN_INTERFACE_CCA_SERVICE;
#endif
}
#endif


