/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief SystemSet Handler - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_SYSTEMSET_HANDLER_H
#define DIAGLIB_SYSTEMSET_HANDLER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#include "../tclServiceHandler.h"
#include "../tclSystemSetIF.h"
#include "../tclSystemSetListenerIF.h"
#include "../Enumerations.h"

#include <utility>
#include <map>
using std::map;
using std::pair;

namespace diaglib {

class tclSystemSetDefaultListener;

typedef pair<tU32, tenSystemSetType> tclSystemListenerMapKey;
typedef map<tclSystemListenerMapKey, tclSystemSetListenerIF*> tclSystemListenerMap;

class tclSystemSetHandler : public tclSystemSetIF,
                                    public tclSystemSetListenerIF
{
private:
   friend class tclInterfaceManager;
   virtual ~tclSystemSetHandler();

   tclSystemListenerMap oListenerMap;

   // eva2hi 09.12.2008
   // Depcrecated and not used, therefor commented out. Remove in future if still not used
   //tVoid vSendSystemSetPrepareIdNotSupported(tContext MsgContext);
   //tVoid vSendSystemSetIdNotSupported(tContext MsgContext);

   // The service handler this handler sends responses to
   tclServiceHandler* poService;
   tclInterfaceManager* poManager;

   // An instance of the default listener used to handle systemset
   // requests that are not handled by the component.
   tclSystemSetDefaultListener* poDefaultListener;

   // This member holds the Unique ID to use as default when a specific
   // system set type is requested but no listener registered for the
   // provided ID.
   tU32 au32MainId[DIAGLIB_SYSTEM_SET_TYPE_MAX+1];

public:
    tclSystemSetHandler(); // Not implemented, do not use
    tclSystemSetHandler(const tclSystemSetHandler&); // Not implemented, do not use
    tclSystemSetHandler& operator=(const tclSystemSetHandler&); // Not implemented, do not use

   tclSystemSetHandler(
                                 tclServiceHandler* poServiceHandler,
                                 tclInterfaceManager* poResponsibleManager
                              );

   /***********************************************************************//**
   * SystemSet Interface functions (Component -> SystemSetHandler)
   *//*************************************************************************/
   virtual tBool bSendSystemSetResult (
                                        tenSystemSetResult enSystemSetResult,
                                        const tclParameterVector& oErrorList,
                                        tContext MsgContext
                                      );

   virtual tBool bSendSystemSetPrepareResult (
                                               tenSystemSetResult enSystemSetResult,
                                               const tclParameterVector& oErrorList,
                                               tContext MsgContext
                                             );



   virtual tBool bAcknowledgeSystemSetFinished (
                                                 tContext MsgContext
                                               );

   virtual tBool bSendSystemSetCheckResult (
                                             tenSystemSetResult enSystemSetResult,
                                             const tclParameterVector& oValueList,
                                             tContext MsgContext
                                           );

   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   );

   virtual tVoid vRegisterListener (
                                     tU32 u32Id,
                                     tenSystemSetType u32SystemSetType,
                                     tclSystemSetListenerIF* poSystemsetListener
                                   );

   virtual tVoid vRegisterListener (
                                     tU32 u32Id,
                                     tclSystemSetListenerIF* poSystemsetListener
                                   );

   /***********************************************************************//**
   * SystemSet Listener Interface (Service Handler -> SystemSet Handler)
   *//*************************************************************************/
   virtual tU32 vOnSystemSet (
                               tU32 u32SystemSetID,
                               tenSystemSetType u32SystemSetType,
                               tContext MsgContext
                             );

   virtual tU32 vOnSystemSetFinished (
                                       tU32 u32SystemSetID,
                                       tenSystemSetType u32SystemSetType,
                                       tContext MsgContext
                                     );

   virtual tU32 vOnSystemSetPrepare (
                                       tU32 u32SystemSetID,
                                       tenSystemSetType u32SystemSetType,
                                       tContext MsgContext
                                    );

   virtual tU32 vOnSystemSetCheck (
                                    tU32 u32SystemSetID,
                                    tenSystemSetType u32SystemSetType,
                                    tContext MsgContext
                                   );

   /***********************************************************************//**
   * Diagnosis Interface functions
   *//*************************************************************************/
   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId);
};

}

#endif // DIAGLIB_SYSTEMSET_HANDLER_H

