/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Routine control handler - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_ROUTINE_CTRL_HANDLER

#include "tclRoutineControlHandler.h"

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "../tclInterfaceManager.h"
#include "../tclRoutineControlListenerIF.h"
#include "../tclHelperFunctions.h"

#include "../Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_ROUTINECONTROL
#include "trcGenProj/Header/tclRoutineControlHandler.cpp.trc.h"
#endif

namespace diaglib {

tclRoutineControlHandler::tclRoutineControlHandler (
                                                      tclServiceHandler* poServiceHandler,
                                                      tclInterfaceManager* poResponsibleManager
                                                   ):
                                                      poService(poServiceHandler),
                                                      poManager(poResponsibleManager)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_CONSTRUCTOR);

   if(poServiceHandler == OSAL_NULL || poResponsibleManager == OSAL_NULL)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }

   if(poService != OSAL_NULL)
      poService->vRegisterRoutineControlListener(this);


}

tclRoutineControlHandler::~tclRoutineControlHandler()
{
    poManager = OSAL_NULL;
    poService = OSAL_NULL;
    _BP_TRY_BEGIN
    {
        oListenerMap.clear();
    }
    _BP_CATCH_ALL
    {

    }
    _BP_CATCH_END
}

tBool tclRoutineControlHandler::bSendRoutineCtrlMethodResult (
                                                               tenRoutineCtrlResult enRoutineStatus,
                                                               const tclParameterVector& oRoutineResult,
                                                               tContext MsgContext
                                                             )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_SEND_ROUTINE_CTRL_MR);

   if(poService == OSAL_NULL )
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return FALSE;
   }

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_OUTGOING_MESSAGE_ADV_START, poService->u32GetAppIdentifier() );
   DIAGLIB_TRACE_INFO(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_MESSAGE_TYPE_ROUTINE_CTRL_MR);
   tBool bResult;

   if(OSAL_NULL == MsgContext)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      bResult =  false;
   }
   else
   {
      DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_FORWARDING_RSP_WITH_CTXT, static_cast<tU32>(MsgContext));
      bResult = poService->bSendRoutineCtrlMethodResult ( enRoutineStatus,
                                                          oRoutineResult,
                                                          MsgContext
                                                        );
   }

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_OUTGOING_MESSAGE_ADV_STOP, poService->u32GetAppIdentifier());


   return bResult;
}

tBool tclRoutineControlHandler::bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   )
{
   diaglib_FuncTrace fnctrc(I_DIAGLIB_F_SEND_DIAGLIB_ERROR);

   tclParameterVector oResultVector;
   oResultVector = oCreateErrorVector(enErrorCode);


   return bSendRoutineCtrlMethodResult( EN_ROUTINE_CONTROL_NOT_OK,
                                       oResultVector,
                                       MsgContext
                                     );
}

tVoid tclRoutineControlHandler::vRegisterListener ( tU32 u32Id, tclRoutineControlListenerIF* poRoutineListener )
{
   ETG_TRACE_USR4_THR(( "--> tclRoutineControlHandler::vRegisterListener"));
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_REGISTER_LISTENER);
   if(OSAL_NULL == poService)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }
   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_APPLICATION_ID, poService->u32GetAppIdentifier());

   if(OSAL_NULL == poRoutineListener)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   oListenerMap[u32Id] = poRoutineListener;
   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_ADDED_LISTENER_ID, u32Id);
   ETG_TRACE_COMP_THR(( "--- tclRoutineControlHandler::vRegisterListener => Id:%d",u32Id));

   ETG_TRACE_USR4_THR(( "<-- tclRoutineControlHandler::vRegisterListener"));
}

tU32 tclRoutineControlHandler::vOnGetRoutineResult (
                                      tU32 u32RoutineId,
                                      tContext MsgContext
                                    )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_GET_ROUTINE_RESULT);

   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService) return U32_DIAGLIB_RETURN_NOT_OK;

   // Lint 1702 -> comparison of std iterators. We have no influence on implementation
   std::map<tU32, tclRoutineControlListenerIF*>::iterator iter = oListenerMap.find(u32RoutineId);
   if(iter == oListenerMap.end())//lint !e1702
   {
      DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, W_DIAGLIB_ID_NOT_SUPPORTED_APPID, poService->u32GetAppIdentifier());
      DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, W_DIAGLIB_ID_NOT_SUPPORTED_ID, u32RoutineId);
      vSendRoutineCtrlIdNotSupported(MsgContext);
      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_FORWARDING_MSG_WITH_CTXT, static_cast<tU32>(MsgContext));
      u32Ret = oListenerMap[u32RoutineId]->vOnGetRoutineResult(
                                                                  u32RoutineId,
                                                                  MsgContext
                                                               );
   }

   return u32Ret;
}

tU32 tclRoutineControlHandler::vOnRoutineControlAbort (
                                         tU32 u32RoutineId,
                                         tContext MsgContext
                                       )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_ROUTINE_CONTROL_ABORT);

   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService) return U32_DIAGLIB_RETURN_NOT_OK;

   // Lint 1702 -> comparison of std iterators. We have no influence on implementation
   std::map<tU32, tclRoutineControlListenerIF*>::iterator iter = oListenerMap.find(u32RoutineId);
   if(iter == oListenerMap.end())//lint !e1702
   {
      DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, W_DIAGLIB_ID_NOT_SUPPORTED_APPID, poService->u32GetAppIdentifier());
      DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, W_DIAGLIB_ID_NOT_SUPPORTED_ID, u32RoutineId);
      vSendRoutineCtrlIdNotSupported(MsgContext);
      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_FORWARDING_MSG_WITH_CTXT, static_cast<tU32>(MsgContext));
      u32Ret = oListenerMap[u32RoutineId]->vOnRoutineControlAbort (
                                                                     u32RoutineId,
                                                                     MsgContext
                                                                  );
   }

   return u32Ret;
}

tU32 tclRoutineControlHandler::vOnRoutineControlStart (
                                         tU32 u32RoutineId,
                                         tU32 u32Bitmask,
                                         const tclParameterVector& oParamVector,
                                         tContext MsgContext
                                       )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_ROUTINE_CONTROL_START);
   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService) return U32_DIAGLIB_RETURN_NOT_OK;

   // Lint 1702 -> comparison of std iterators. We have no influence on implementation
   std::map<tU32, tclRoutineControlListenerIF*>::iterator iter = oListenerMap.find(u32RoutineId);
   if (iter == oListenerMap.end())//lint !e1702
   {
      DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, W_DIAGLIB_ID_NOT_SUPPORTED_APPID, poService->u32GetAppIdentifier());
      DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, W_DIAGLIB_ID_NOT_SUPPORTED_ID, u32RoutineId);
      vSendRoutineCtrlIdNotSupported(MsgContext);
      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_ROUTINECONTROL, I_DIAGLIB_FORWARDING_MSG_WITH_CTXT, static_cast<tU32>(MsgContext));

      u32Ret = oListenerMap[u32RoutineId]->vOnRoutineControlStart (
                                                                    u32RoutineId,
                                                                    u32Bitmask,
                                                                    oParamVector,
                                                                    MsgContext
                                                                  );
   }

   return u32Ret;
}

tclDiagnosisIF* tclRoutineControlHandler::poGetInterface(tenDiagHandlerInterfaces u16InterfaceId)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_GETINTERFACE);

   tclDiagnosisIF* poReturnIF;

   poReturnIF = poManager->poGetInterface(u16InterfaceId);


   return poReturnIF;
}

tVoid tclRoutineControlHandler::vSendRoutineCtrlIdNotSupported(tContext MsgContext)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_SEND_ROUTINE_CTRL_ID_NOT_SUPP);

   tclParameterVector oErrorVector;

   trParameter rErrorParam;
   rErrorParam.enType = EN_PARAMETER_TYPE_U8ERROR;
   rErrorParam.u8ErrorValue = EN_ERROR_ID_NOT_SUPPORTED;

   oErrorVector.push_back(rErrorParam);

   bSendRoutineCtrlMethodResult (
                                    EN_ROUTINE_CONTROL_NOT_OK,
                                    oErrorVector,
                                    MsgContext
                                );


}

}
