/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief DiagData Handler - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_DIAGDATA_HANDLER

#include "tclDiagDataHandler.h"

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "../tclDiagnosisDataListenerIF.h"
#include "../tclInterfaceManager.h"
#include "../tclHelperFunctions.h"

#include "../Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_DIAGNOSISDATA
#include "trcGenProj/Header/tclDiagDataHandler.cpp.trc.h"
#endif

namespace diaglib {


tclDiagDataHandler::tclDiagDataHandler (
                                       tclServiceHandler* poServiceHandler,
                                       tclInterfaceManager* poResponsibleManager
                                    ):
                                       poService(poServiceHandler),
                                       poManager(poResponsibleManager)
{
   ETG_TRACE_USR3_THR(( "--> tclDiagDataHandler::tclDiagDataHandler"));

   if(poServiceHandler == OSAL_NULL)
   {
      ETG_TRACE_COMP_THR(( "!!! tclDiagDataHandler::tclDiagDataHandler => ERROR: poServiceHandler == OSAL_NULL"));
   }
   else if(poResponsibleManager == OSAL_NULL)
   {
      ETG_TRACE_COMP_THR(( "!!! tclDiagDataHandler::tclDiagDataHandler => ERROR: poResponsibleManager == OSAL_NULL"));
   }


   if(poService != OSAL_NULL)
   {
      poService->vRegisterDiagnosisDataListener(this);
   }

    ETG_TRACE_USR3_THR(( "<-- tclDiagDataHandler::tclDiagDataHandler"));
}


tclDiagDataHandler::~tclDiagDataHandler()
{
//   diaglib_FuncTrace oTrace(I_DIAGLIB_F_DESTRUCTOR);

   poManager = OSAL_NULL;
   poService = OSAL_NULL;
   _BP_TRY_BEGIN
   {
       oListenerMap.clear();
   }
   _BP_CATCH_ALL
   {

   }
   _BP_CATCH_END
}

tBool tclDiagDataHandler::bSendDiagnosisDataResult   (
                                                     tenDiagDataResult enReadResult,
                                                     const tclParameterVector& oReadValues,
                                                     tContext MsgContext
                                                  )
{
   ETG_TRACE_USR3_THR(( "--> tclDiagDataHandler::bSendDiagnosisDataResult"));

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!! tclDiagDataHandler::bSendDiagnosisDataResult => ERROR: OSAL_NULL == poService"));
      return FALSE;
   }
   ETG_TRACE_COMP_THR(( "--- tclDiagDataHandler::bSendDiagnosisDataResult => AppId=%d",poService->u32GetAppIdentifier()));
   tBool bResult;

   if(OSAL_NULL == MsgContext)
   {
      ETG_TRACE_ERR_THR(( "!!! tclDiagDataHandler::bSendDiagnosisDataResult => ERROR: OSAL_NULL == MsgContext"));
      bResult =  false;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclDiagDataHandler::bSendDiagnosisDataResult => MsgContext=%d",static_cast<tU32>(MsgContext)));
      bResult = poService->bSendDiagnosisDataResult ( enReadResult,
                                                          oReadValues,
                                                          MsgContext
                                                        );
   }

   ETG_TRACE_USR3_THR(( "<-- tclDiagDataHandler::bSendDiagnosisDataResult"));
   return bResult;
}


tBool tclDiagDataHandler::bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   )
{
   diaglib_FuncTrace fnctrc(I_DIAGLIB_F_SEND_DIAGLIB_ERROR);

   tclParameterVector oResultVector;
   oResultVector = oCreateErrorVector(enErrorCode);


   return bSendDiagnosisDataResult( EN_DIAGDATA_NOT_OK,
                                           oResultVector,
                                           MsgContext
                                         );
}

tVoid tclDiagDataHandler::vRegisterListener ( tU32 u32Id, tclDiagnosisDataListenerIF* poDiagDataListener )
{
   ETG_TRACE_USR4_THR(( "--> tclDiagDataHandler::vRegisterListener"));
   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!!tclDiagDataHandler::vRegisterListener => ERROR: OSAL_NULL == poService"));
      return;
   }

   if(OSAL_NULL == poDiagDataListener)
   {
      ETG_TRACE_ERR_THR(( "!!!tclDiagDataHandler::vRegisterListener => ERROR: OSAL_NULL == poIoListener"));
      return;
   }

   ETG_TRACE_COMP_THR(( "--- tclDiagDataHandler::vRegisterListener => Id:%d",u32Id));
   oListenerMap[u32Id] = poDiagDataListener;

   ETG_TRACE_USR4_THR(( "<-- tclDiagDataHandler::vRegisterListener"));
}

tclDiagnosisIF* tclDiagDataHandler::poGetInterface(tenDiagHandlerInterfaces u16InterfaceId)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_GETINTERFACE);

   tclDiagnosisIF* poReturnIF;

   poReturnIF = poManager->poGetInterface(u16InterfaceId);


   return poReturnIF;
}


tU32 tclDiagDataHandler::vOnDiagnosisDataRead (
                                            tU32 u32DiagDataId,
                                            diaglib::tContext MsgContext
                                            )
{
   ETG_TRACE_USR3_THR(( "--> tclDiagDataHandler::vOnDiagnosisData"));
   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!! tclDiagDataHandler::vOnDiagnosisData => ERROR: OSAL_NULL == poService"));
      ETG_TRACE_USR3_THR(( "<-- tclDiagDataHandler::vOnDiagnosisData"));
      return U32_DIAGLIB_RETURN_NOT_OK;
   }

   std::map<tU32, tclDiagnosisDataListenerIF*>::iterator iter = oListenerMap.find(u32DiagDataId);
   if (iter == oListenerMap.end())
   {
      ETG_TRACE_ERR_THR(( "!!!tclDiagDataHandler::vOnDiagnosisData => Unkown AppId %d",poService->u32GetAppIdentifier()));
      ETG_TRACE_ERR_THR(( "!!!tclDiagDataHandler::vOnDiagnosisData => Unkown Control ID %d",u32DiagDataId));
      vSendDiagnosisDataIdNotSupported(MsgContext);

      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclDiagDataHandler::vOnDiagnosisData => Forwarding Message to Listener"));

      u32Ret = oListenerMap[u32DiagDataId]->vOnDiagnosisDataRead(u32DiagDataId,MsgContext);
   }

   ETG_TRACE_USR3_THR(( "<-- tclDiagDataHandler::vOnDiagnosisData"));
   return u32Ret;
}

tU32 tclDiagDataHandler::vOnDiagnosisDataWrite (
                                            tU32 u32DiagDataId,
                                            const diaglib::tclParameterVector& oParamVector,
                                            diaglib::tContext MsgContext
                                            )
{
   ETG_TRACE_USR3_THR(( "--> tclDiagDataHandler::vOnDiagnosisData"));
   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!! tclDiagDataHandler::vOnDiagnosisData => ERROR: OSAL_NULL == poService"));
      return U32_DIAGLIB_RETURN_NOT_OK;
   }

   std::map<tU32, tclDiagnosisDataListenerIF*>::iterator iter = oListenerMap.find(u32DiagDataId);
   if ( iter == oListenerMap.end())
   {
      ETG_TRACE_ERR_THR(( "!!!tclDiagDataHandler::vOnDiagnosisData => Unkown AppId %d",poService->u32GetAppIdentifier()));
      ETG_TRACE_ERR_THR(( "!!!tclDiagDataHandler::vOnDiagnosisData => Unkown Control ID %d",u32DiagDataId));
      vSendDiagnosisDataIdNotSupported(MsgContext);

      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclDiagDataHandler::vOnDiagnosisData => Forwarding Message to Listener"));

      u32Ret = oListenerMap[u32DiagDataId]->vOnDiagnosisDataWrite (
                                                                 u32DiagDataId,
                                                                 oParamVector,
                                                                 MsgContext
                                                              );
   }

   ETG_TRACE_USR3_THR(( "<-- tclDiagDataHandler::vOnDiagnosisData"));
   return u32Ret;
}

tVoid tclDiagDataHandler::vSendDiagnosisDataIdNotSupported(tContext MsgContext)
{
   ETG_TRACE_USR3_THR(( "--> tclDiagDataHandler::vSendDiagnosisDataWriteIdNotSupported"));

   tclParameterVector oErrorVector;

   trParameter rErrorParam;
   rErrorParam.enType = EN_PARAMETER_TYPE_U8ERROR;
   rErrorParam.u8ErrorValue = EN_ERROR_ID_NOT_SUPPORTED;

   oErrorVector.push_back(rErrorParam);

   bSendDiagnosisDataResult (
                                    EN_DIAGDATA_NOT_OK,
                                    oErrorVector,
                                    MsgContext
                                );

   ETG_TRACE_USR3_THR(( "<-- tclDiagDataHandler::vSendDiagnosisDataWriteIdNotSupported"));
}

}// namespace diaglib {
