/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-10
*
* \brief Main header - Diagnosis Library - Introduced in MFD Nav
*
* Include this header file to use the diagnosis library. Make use of the
* following defines depending on the nature of diagnosis services you want 
* to offer:
*
* \li DIAGLIB_INCLUDE_ROUTINE_CONTROL -> Includes complete routine control support
* \li DIAGLIB_INCLUDE_IO_CONTROL -> Includes complete IO control support
* \li DIAGLIB_INCLUDE_SYSTEM_SET -> Includes complete system setting support
* \li DIAGLIB_INCLUDE_DIAGNOSIS_DATA -> Includes complete diagnosis data support
* \li DIAGLIB_INCLUDE_GENERIC -> Includes support for all four groups
*
* You don't need any of the other defines used in this file.
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_INCLUDE_GENERIC
   #define DIAGLIB_INCLUDE_ROUTINE_CONTROL
   #define DIAGLIB_INCLUDE_IO_CONTROL
   #define DIAGLIB_INCLUDE_SYSTEM_SET
   #define DIAGLIB_INCLUDE_DIAGNOSIS_DATA
   #define DIAGLIB_INCLUDE_ADMINISTRATIVE
#endif

#ifdef DIAGLIB_INCLUDE_ROUTINE_CONTROL
   #include "tclRoutineControlListenerIF.h"
   #include "tclRoutineControlIF.h"

   #define DIAGLIB_INCLUDE_ADMINISTRATIVE
#endif

#ifdef DIAGLIB_INCLUDE_IO_CONTROL
   #include "tclIoControlListenerIF.h"
   #include "tclIoControlIF.h"
   #define DIAGLIB_INCLUDE_ADMINISTRATIVE
#endif

#ifdef DIAGLIB_INCLUDE_SYSTEM_SET
   #include "tclSystemSetListenerIF.h"
   #include "tclSystemSetDefaultListener.h"
   #include "tclSystemSetIF.h"

   #define DIAGLIB_INCLUDE_ADMINISTRATIVE
#endif

#ifdef DIAGLIB_INCLUDE_DIAGNOSIS_DATA
   #include "tclDiagnosisDataListenerIF.h"
   #include "tclDiagnosisDataIF.h"

   #define DIAGLIB_INCLUDE_ADMINISTRATIVE
#endif


#ifdef DIAGLIB_INCLUDE_ADMINISTRATIVE

   #include "Enumerations.h"               //lint !e537 Info 537 , eliminating lint warnings Repeated include file
   #include "tclHelperFunctions.h"
   #define DIAGLIB_ALREADY_INCLUDED_IDSPEC
   #include "IdSpec.h"
   #include "IdSpecEnum.h"
   #include "tclDiagnosisInterfaceFactory.h"
   #include "tclDiagnosisIF.h"               //lint !e537 Info 537 , eliminating lint warnings Repeated include file

   #include "tclCCAServiceIF.h"
   #include "tclCSFWServiceIF.h"
   #include "CCA/tclServiceDiaglib.h"
#endif

#ifdef DIAGLIB_INCLUDE_ID_SPEC_TYPES
   #ifndef DIAGLIB_ALREADY_INCLUDED_IDSPEC
      #include "IdSpec.h"
   #endif
   #include "IdSpecEnum.h"
#endif

/** 
 * \mainpage Diagnosis Library (diaglib)
 *
 * \section intro Introduction
 *
 * The diagnosis library was introduced to generalize and capsulate the
 * communication between fc_diagnosis and other components. Components use
 * its API to provide services to diagnosis. The interface is designed 
 * in a rather generic way and is not component specific. Only diagnosis 
 * specific services, that are not part of the components original interface
 * (e.g. frequency_set of a tuner component), are handled through this 
 * interface. <br>
 * To use the library include the \link diaglib_if.h main header file. \endlink
 * Remember to specifiy by defines what parts of the library your component
 * uses.
 * All API classes are available in the namespace diaglib!
 *
 * \subsection unID Unique IDs
 * The Component specific part is abstracted using the concept of unique IDs. 
 * For example has every test an unique ID assigned. This ID specifies what to 
 * be done and what kind of additional data maybe transported with the request 
 * or response of for a test. These IDs are unique not only in project scope 
 * but in a general scope. This assures that components, that are reused in 
 * another project and have a specific test implemented for a once defined ID, 
 * won't have to change anything if the nature of the test doesn't change. This
 * exact test will always be specified by this ID. If the test changes a new ID
 * is issued and components implementing the old test are not affected. The IDs
 * will be defined in discussion with the component responsibles and will be 
 * specified in a XML document that will be delivered along with the library
 * itself.
 *
 * \subsection ucg Use case groups
 * The interface splits the communication in four use case groups.
 * \li Routine Control
 * \li IO control
 * \li System Setting (DefSet)
 * \li Diagnosis Data 
 * <br>
 * All of these groups have their own set of unique IDs, i.e. a routine control
 * ID can be identical to a IO control ID without being related to it.<br>
 * <b>Routine Control:</b> The Routinecontrol interface is used to trigger
 * longer running tests. The interface supports the sending of responses that
 * contain additional information specified for each ID.<br>
 * <b>Io Control:</b> The IO control interface is used to set a component into 
 * an exclusive status used to test. Examples would be a test-tone on a speaker
 * or a display test. IO control provides freeze and unfreeze messages to
 * trigger the exclusiveness.<br>
 * <b>System Setting:</b> This interface provides what was formerly known as
 * default setting. Now Default setting is a subset of what is handled by this
 * new interface. Additionally this interface triggers coding and calibration
 * requests that are currently used in some projects. Default settings can be
 * executed inside of a preperation phase, that means before the actual 
 * SystemSet the component is informed and only after it sends a positive 
 * response the SystemSet happens by sending a second message.<br>
 * <b>Diagnosis Data:</b> This interface is used to simply read or write data
 * the component does not offer in its original interface.
 *
 * \section init Initialisation
 * This section decribes how the library is being initialized for a
 * component in order to provide diagnostic services with its help.
 * The "entry point" to the library is the 
 * diaglib::tclDiagnosisInterfaceFactory class, 
 * it implements the singleton pattern and provides users of the library with 
 * the main interface and triggers initialisation of the communication 
 * mechanisms. The sequence diagram shows the process of setting up the system.
 * Grey classes are part of the library. As a result you receive a pointer
 * to the main diaglib::tclDiagnosisIF .
 * \image html seqInitFramework.png
 *
 * \section addIF Additional interfaces
 * After the connection is initialized the only interface that is available to
 * you is the main interface. Its only functionality is to provide additional
 * interfaces for various tasks. The most important interface for you is
 * probably the one providing access to the internal service object 
 * (e.g. diaglib::tclCCAServiceIF). But also all interfaces to communicate 
 * with diagnosis
 * are available. How components can retrieve additional interfaces is 
 * described in the following sequence diagram. The pointer you get in return
 * is of the type "pointer to the main interface", you have to dynamic_cast it
 * to the pointer type of the interface you requested. This is required in
 * order to ensure that the main interface does not change in the case
 * additional interfaces might be added in the future (maybe for diaglog).
 * \image html seqGetNewIF.png
 *
 * \section regIF Register listener
 * In order to receive messages from diagnosis you have to implement a Listener
 * interface and register it with the library. For example if you need to do
 * System Set handling for a specific system set group you would derive a class
 * from the diaglib::tclSystemSetListenerIF and implement the three methods it 
 * provides.
 * Then during your initialisation phase and after initializing diaglib you
 * would register your diaglib::tclSystemSetListenerIF with the 
 * diaglib::tclSystemSetIF. If there is currently no work to do for your 
 * component, but you implement the SystemSet interface for future use anyway,
 * you can use the SystemSetDefaultListener. It simply sends a positive response
 * on any SystemSet request you registered it for. When calling
 * one of the register methods you have to provide the unique ID and (if you
 * want) the type of SystemSet you handle in this Listener. So you are free
 * to handle all incoming requests in one listener or create one for every
 * ID, type combination. See the following sequence diagram:
 * \image html seqRegisterListener.png
 *
 * \section deInit Deinitialisation
 * On shutdown of the system, or when diagnosis - component communication is
 * not needed anymore for any other reason the component should disconnect 
 * and destroy all its interfaces. To accomplish this, the factory provides a 
 * method that takes one of your interfaces as a parameter and in the 
 * background destroys all objects and the connection to diagnosis. After 
 * calling this function you are not further allowed to use any of your 
 * interface pointers, as they are invalid from now on.
 * You are responsible for destroying your Listener objects.
 * After calling the Destroy function on the factory and destroying the
 * listeners the communication is ended successfully.
 * \image html seqDelFramework.png
 *
 * \section useLib Using the library for diagnostic services
 * After the component registered its listener(s) communuication can start.
 * Requests of diagnosis result in a call to your listener that you registered
 * for the requested ID and type. Your responses are sent using the appropriate
 * interface provided by diaglib. See a system set sequence for a Production
 * default setting process as example:
 * \image html seqSystemSet.png
 *  
 * \section errors Error handling responsibilities
 * \li Case: Diagnosis sends message with unsupported ID<br>
 * Responsible: Diaglib<br>
 * Description: Diaglib checks every incoming message if its ID is supported by 
 * the addressed component. Unsupported messages are rejected.<br>
 * \li Case: Diagnosis sends message with supported ID but invalid parameter 
 * signature in the vector.<br>
 * Resposible: <b>Component</b><br>
 * Description: As diaglib does not know about the ID definition this must be
 * checked by component. Reject invalid messages with result "XXX_NOT_OK" and 
 * ErrorCode "INCOMPATIBLE_PARAMETER_SIGNATURE" in the result vector.
 * \li Case: Diagnosis requests a routine result that is not available.<br>
 * Responsible: <b>Component</b><br>
 * Description: Inform diagnosis that result is not available. Return Routine
 * status "EN_ROUTINE_NOT_OK". and appropriate internal error code. Diagnosis 
 * then has to decide if it waits a little longer (if it triggered the test 
 * before) or if it triggers the test now.
 * \li Case: Protocol specific errors like unsupported op-codes or function IDs<br>
 * Responsible: Diaglib<br>
 * Description: Component does not need to care for this. Diaglib uses the 
 * protocols mechanism to handle these errors.
 * \li Case: Service unavailable<br>
 * Responsible: CCA Framework<br>
 * Description: If the service (not the whole application) is unavailable 
 * messages are rejected automatically. Nevertheless the application on
 * componet side is responsible for setting the correct service states through
 * the provided interface.
 * \li Case: Orphaned messages<br>
 * Responsible: <b>Component</b><br>
 * Description: As the diaglib is stateless is does not keep track of messages
 * it transports to the component. So if a message arrives with an IO Control - 
 * MethodStart - UNFREEZE it is delivered to the component, whether or not
 * there was a FREEZE msg with the same ID before. Component simply answers
 * with an IO_CONTROL_NOT_OK on orphaned messages and provide the appropriate
 * error code.
 *
 * <br><br>Sending errors works like sending normal responses to requests. As
 * result you send "XXX_NOT_OK" and the vector of the result message has
 * exactly one entry of type EN_TYPE_INTERNAL_ERROR . The value of this entry
 * describes the error that occured.
 */
