/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-21
*
* \brief Trace - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifndef DIAGLIB_TRACE_H
#define DIAGLIB_TRACE_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

//#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DIAGLIB_TRACE_W    ET_TRACE_WARNING_BIN
#define DIAGLIB_TRACE_I    ET_TRACE_INFO_BIN
#define DIAGLIB_TRACE_E    ET_TRACE_ERROR_BIN

// Trace Classes. Logical seperation of trace output into groups
#define TR_CLASS_DIAGLIB_GENERAL                  (tU16) ( TR_COMP_DIAGNOSIS + 0x13 )
#define TR_CLASS_DIAGLIB_FLOW                     (tU16) ( TR_COMP_DIAGNOSIS + 0x14 )
#define TR_CLASS_DIAGLIB_CCA                      (tU16) ( TR_COMP_DIAGNOSIS + 0x15 )
#define TR_CLASS_DIAGLIB_SYSTEMSET                (tU16) ( TR_COMP_DIAGNOSIS + 0x16 )
#define TR_CLASS_DIAGLIB_ROUTINECONTROL           (tU16) ( TR_COMP_DIAGNOSIS + 0x17 )
#define TR_CLASS_DIAGLIB_IOCONTROL                (tU16) ( TR_COMP_DIAGNOSIS + 0x18 )
#define TR_CLASS_DIAGLIB_DIAGNOSISDATA            (tU16) ( TR_COMP_DIAGNOSIS + 0x19 )
#define TR_CLASS_DIAGLIB_TSH_TP                    (tU16) (TR_COMP_DIAGNOSIS + 0x10) // same as in fc_diagnosis

enum tenTrcTraceClass
{
   TR_CLASS_ET_DIAGLIB_GENERAL         = TR_CLASS_DIAGLIB_GENERAL,
   TR_CLASS_ET_DIAGLIB_FLOW            = TR_CLASS_DIAGLIB_FLOW,
   TR_CLASS_ET_DIAGLIB_CCA             = TR_CLASS_DIAGLIB_CCA,
   TR_CLASS_ET_DIAGLIB_SYSTEMSET       = TR_CLASS_DIAGLIB_SYSTEMSET,
   TR_CLASS_ET_DIAGLIB_ROUTINECONTROL  = TR_CLASS_DIAGLIB_ROUTINECONTROL,
   TR_CLASS_ET_DIAGLIB_IOCONTROL       = TR_CLASS_DIAGLIB_IOCONTROL,
   TR_CLASS_ET_DIAGLIB_DIAGNOSISDATA   = TR_CLASS_DIAGLIB_DIAGNOSISDATA
};



// Files. Defined at the top of each source file. Used to associate a trace output
// with the file that issued it.
#define F_DIAGLIB_DIAG_IF_FACTORY                  0x01   // tclDiagnosisInterfaceFactory.cpp
#define F_DIAGLIB_IF_MANAGER                       0x02   // tclInterfaceManager.cpp
#define F_DIAGLIB_CCA_SERVICE_HANDLER              0x03   // tclCcaServiceHandler.cpp
#define F_DIAGLIB_SYSTEMSET_HANDLER                0x04   // tclSystemSetHandler.cpp
#define F_DIAGLIB_SYSTEMSET_DEF_LISTENER           0x05   // tclSystemSetDefaultListener.cpp
#define F_DIAGLIB_LEGACY_WRAPPER_SERVICE_HANDLER   0x06   // tclServiceHandlerLegacyWrapper.cpp
#define F_DIAGLIB_ROUTINE_CTRL_HANDLER             0x07   // tclRoutineControlHandler.cpp
#define F_DIAGLIB_IOCTRL_HANDLER                   0x08   // tclIoControlHandler.cpp
#define F_DIAGLIB_DIAGDATA_HANDLER                 0x09   // tclDiagDataHandler.cpp
#define F_DIAGLIB_CSFW_SERVICE_HANDLER             0x0a   // tclServiceHandlerCSFW.cpp
#define F_DIAGLIB_MESSAGE_CONTEXT                  0x0b   // tclMessageContext.cpp
#define F_DIAGLIB_MESSAGE_CONTEXT_CCA              0x0c   // tclMessageContextCCA.cpp
#define F_DIAGLIB_MESSAGE_CONTEXT_CSFW             0x0d   // tclMessageContextCSFW.cpp
#define F_DIAGLIB_MESSAGE_CONTEXT_MANAGER          0x0e   // tclMessageContextManager.cpp
#define F_DIAGLIB_CCA_SERVICE_PROXY                0x0f   // tclCCAServiceProxy.cpp
#define F_DIAGLIB_CCA_HELPER                       0x10   // tclCCAHelper.cpp
#define F_DIAGLIB_HELPER_FUNCTIONS                 0x11   // tclHelperFunctions.cpp
#define F_DIAGLIB_SERVICE_DIAGLIB                  0x12   // tclServiceDiaglib.cpp

// Error Traces
#define E_DIAGLIB_UNEXPECTED_NULLPOINTER           0x0001 // Unexpected null pointer.
#define E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP        0x0002 // Fatal: Can not allocate memory on heap.
#define E_DIAGLIB_UNEXPECTED_NEGATIVE_RESPONSE     0x0003 // Unexpected negative response from procedure.
#define E_DIAGLIB_UNKNOWN_PROTOCOL_REQUESTED       0x0004 // Unknown protocol for framework instance requested. Can not proceed.
#define E_DIAGLIB_INTERFACE_UNSUPPORTED            0x0005 // Interface unsupported for current framework instance.
#define E_DIAGLIB_UNKNOWN_INTERFACE_REQUESTED      0x0006 // Unknown Interface requested
#define E_DIAGLIB_EXPECTED_EMPTY_VECTOR            0x0007 // Expected an empty vector
#define E_DIAGLIB_CANT_SEND_MSG_DUE_TO_CTXT        0x0008 // Can not send message, as context not present or wrong context type
#define E_DIAGLIB_UNKNOWN_PARAMETER_TYPE           0x0009 // Unknown parameter type during vector conversion.
#define E_DIAGLIB_ERROR_WHILE_SENDING_MESSAGE      0x000a // Error while sending message.
#define E_DIAGLIB_ERROR_WHILE_DELETING_MESSAGE     0x000b // Error while deleting message.
#define E_DIAGLIB_PARAMETER_WRONG_TYPE             0x000c // Parameter has wrong type. Cast failed.
#define E_DIAGLIB_FRAMEWORK_HAS_BEEN_DELETED       0x000d // Framework instance has already been deleted, no interfaces available.
#define E_DIAGLIB_UNKNOWN_MESSAGE_GRP              0x000e // Unknown message group requested. Group:
#define E_DIAGLIB_REQUEST_INVALID_CTXT             0x000f // Request to invalid message context.
#define E_DIAGLIB_ASSUMES_WRONG_CTX_TYPE           0x0010 // Wrong context message group type assumed.
#define E_DIAGLIB_UNKNOWN_APP_STATE                0x0011 // Unknow application state requested.
#define E_DIAGLIB_UNABLE_TAKE_SEM_UNTIL_TIMEOUT    0x0012 // Unable to take semaphore until timeout occured.
#define E_DIAGLIB_SEM_HANDLE_INVALID               0x0013 // Semaphore handle invalid.
#define E_DIAGLIB_UNABLE_TO_INIT_TIMEOUT_TIMER     0x0014 // Unable to initialize timeout timer.
#define E_DIAGLIB_WORKER_SPAWNING_FAILED           0x0015 // Spawning of worker thread failed. No timeout functionality.
#define E_DIAGLIB_MSG_CONTEXT_ERROR                0x0016 // Error inside retrieved message context.
#define E_DIAGLIB_SENDING_POSITIVE_RESPONSE_FAIL   0x0017 // Sending of positive response failed:
#define E_DIAGLIB_UNEXPECTED_ENUM_VALUE            0x0018 // Unexpected enum value.

// Warn Traces
#define W_DIAGLIB_UNEXPECTED_NULLPOINTER           0x0001 // Unexpected null pointer.
#define W_DIAGLIB_FRAMEWORK_NOT_DELETED            0x0002 // Framework instance has not been deleted before, doing it now.
#define W_DIAGLIB_FRAMEWORK_HAS_BEEN_DELETED       0x0003 // Framework instance has already been deleted, no interfaces available.
#define W_DIAGLIB_NOT_IMPLEMENTED                  0x0004 // Called function not implemented.
#define W_DIAGLIB_NO_CONTEXT_FOUND_FOR_ID          0x0005 // Context ID not found, timed out or never created:
#define W_DIAGLIB_CONTEXT_TIMED_OUT                0x0006 // Context ID timed out:
#define W_DIAGLIB_OPCODE_NOT_SUPPORTED             0x0007 // Opcode is not supported:
#define W_DIAGLIB_UNKNOWN_FUNCTION_ID              0x0008 // Unknown function ID received:
#define W_DIAGLIB_ID_NOT_SUPPORTED_APPID           0x0009 // Component does not support this request. ApplicationID:
#define W_DIAGLIB_ID_NOT_SUPPORTED_ID              0x000a // Component does not support this request. UniqueID:
#define W_DIAGLIB_ID_NOT_SUPPORTED_TYPE            0x000b // Component does not support this request. SystemSet Type:
#define W_DIAGLIB_NEW_STATE_EQUAL_OLD_STATE        0x000d // The new state equals the old one:
#define W_DIAGLIB_UNKNOWN_MSG_RECEIVED             0x000e // Unknown message received.
#define W_DIAGLIB_MESSAGE_HANDLED_BY_DEF_HANDLER   0x000f // Message handled by internal default handler.
#define W_DIAGLIB_USE_DEFAULT_PRIO                 0x0010 // Unable to read worker thread priority from registry, using default:
#define W_DIAGLIB_USE_DEFAULT_STCK                 0x0011 // Unable to read worker thread stack-size from registry, using default:

// Trace Types
#define I_DIAGLIB_INFO                             0x00   // Info
#define I_DIAGLIB_TRACEFLOW_ENTRY                  0x01   // -->
#define I_DIAGLIB_TRACEFLOW_LEAVE                  0x02   // <--
#define I_DIAGLIB_U32_INFO                         0x03   // Info

#define W_DIAGLIB_SIMPLE_WARN                      0x10   // Warning
#define W_DIAGLIB_U32_WARN                         0x13   // Warning
#define E_DIAGLIB_SIMPLE_ERROR                     0x20   // Error
#define E_DIAGLIB_U32_ERROR                        0x23   // Error

// Functions
#define I_DIAGLIB_F_CONSTRUCTOR                    0x0001 // Constructor
#define I_DIAGLIB_F_DESTRUCTOR                     0x0002 // Destructor
#define I_DIAGLIB_F_GETINSTANCE                    0x0003 // poGetInstance
#define I_DIAGLIB_F_CREATEDIAGNOSISINTERFACE       0x0004 // poCreateDiagnosisInterface
#define I_DIAGLIB_F_DELCONNANDFREEIF               0x0005 // bDeleteConnectionAndFreeInterfaces
#define I_DIAGLIB_F_INIT                           0x0006 // vInit
#define I_DIAGLIB_F_GETMAININTERFACE               0x0007 // poGetMainInterface
#define I_DIAGLIB_F_GETINTERFACE                   0x0008 // poGetInterface
#define I_DIAGLIB_F_DELSERVICEHANDLERANDIF         0x0009 // vDeleteServiceHandlerAndInterfaces
#define I_DIAGLIB_F_SEND_SYSTEMSET_MR              0x000a // bSendSystemSetMethodResult
#define I_DIAGLIB_F_SEND_SYSTEMSET_FINISHED_MR     0x000b // bSendSystemSetFinishedMethodResult
#define I_DIAGLIB_F_SEND_SYSTEMSET_PREPARE_MR      0x000c // bSendSystemSetPrepareMethodResult
#define I_DIAGLIB_F_SEND_DIAGDATA_READ_MR          0x000d // bSendDiagnosisReadMethodResult
#define I_DIAGLIB_F_SEND_DIAGDATA_WRITE_MR         0x000e // bSendDiagnosisWriteMethodResult
#define I_DIAGLIB_F_SEND_IOCTRL_MR                 0x000f // bSendIoControlMethodResult
#define I_DIAGLIB_F_SEND_ROUTINE_CTRL_MR           0x0010 // bSendRoutineCtrlMethodResult
#define I_DIAGLIB_F_SEND_GET_ROUTINE_RESULT_MR     0x0011 // bSendGetRoutineResultMethodResult
#define I_DIAGLIB_F_REGISTER_SYSTEMSET_LISTENER    0x0012 // vRegisterSystemSetListener
#define I_DIAGLIB_F_REGISTER_DIAGDATA_LISTENER     0x0013 // vRegisterDiagDataListener
#define I_DIAGLIB_F_REGISTER_ROUTINE_CTRL_LISTENER 0x0014 // vRegisterRoutineControlListener
#define I_DIAGLIB_F_REGISTER_IOCTRL_LISTENER       0x0015 // vRegisterIoControlListener
#define I_DIAGLIB_F_GET_SERVICE_ID                 0x0016 // u16GetServiceId
#define I_DIAGLIB_F_ON_NEW_APP_STATE               0x0017 // vOnNewAppState
#define I_DIAGLIB_F_ON_SERVICE_STATE               0x0018 // vOnServiceState
#define I_DIAGLIB_F_ON_UNKNOWN_MESSAGE             0x0019 // vOnUnknownMessage
#define I_DIAGLIB_F_HANDLE_ROUTINE_CTRL            0x001a // vHandleRoutineControl
#define I_DIAGLIB_F_HANDLE_GET_ROUTINE_RESULT      0x001b // vHandleGetRoutineResult
#define I_DIAGLIB_F_HANDLE_IOCTRL                  0x001c // vHandleIOControl
#define I_DIAGLIB_F_HANDLE_SYSTEMSET_PREPARE       0x001d // vHandleSystemSetPrepare
#define I_DIAGLIB_F_HANDLE_SYSTEMSET_FINISHED      0x001e // vHandleSystemSetFinished
#define I_DIAGLIB_F_HANDLE_SYSTEMSET               0x001f // vHandleSystemSet
#define I_DIAGLIB_F_HANDLE_DIAGDATA_READ           0x0020 // vHandleDiagnosisRead
#define I_DIAGLIB_F_HANDLE_DIAGDATA_WRITE          0x0021 // vHandleDiagnosisWrite
#define I_DIAGLIB_F_SEND_ERROR                     0x0022 // vSendError
#define I_DIAGLIB_F_INIT_MR_SERVICE_DATA           0x0023 // vInitMethodResultServiceData
#define I_DIAGLIB_F_FILL_CCA_VL_FROM_VEC           0x0024 // vFillCcaValueListFromVector
#define I_DIAGLIB_F_CONVERT_CCA_UN_TO_DIAGLIB_UN   0x0025 // vConvertCcaUnionToDiaglibUnion
#define I_DIAGLIB_F_CONVERT_DIAGLIB_UN_TO_CCA_UN   0x0026 // vConvertDiaglibUnionToCcaUnion
#define I_DIAGLIB_F_SEND_SYSTEMSET_RESULT          0x0027 // bSendSystemSetResult
#define I_DIAGLIB_F_SEND_SYSTEMSET_PREPARE_RESULT  0x0028 // bSendSystemSetPrepareResult
#define I_DIAGLIB_F_ACK_SYSTEMSET_FINISHED         0x0029 // bAcknowledgeSystemSetFinished
#define I_DIAGLIB_F_REGISTER_LISTENER              0x002a // vRegisterListener
#define I_DIAGLIB_F_ON_SYSTEMSET                   0x002b // vOnSystemSet
#define I_DIAGLIB_F_ON_SYSTEMSET_FINISHED          0x002c // vOnSystemSetFinished
#define I_DIAGLIB_F_ON_SYSTEMSET_PREPARE           0x002d // vOnSystemSetPrepare
#define I_DIAGLIB_F_SEND_SYSSET_ID_NOT_SUPP        0x002e // vSendSystemSetIdNotSupported
#define I_DIAGLIB_F_SEND_SYSSET_PREP_ID_NOT_SUPP   0x002f // vSendSystemSetPrepareIdNotSupported
#define I_DIAGLIB_F_ADD_CONTEXT                    0x0030 // poAddContext
#define I_DIAGLIB_F_GET_CONTEXT_BACK               0x0031 // bGetContextBack
#define I_DIAGLIB_F_HANDLE_SECONDS_PASSED          0x0032 // vHandleSecondPassed
#define I_DIAGLIB_F_ON_SECONDS_PASSED              0x0033 // vOnSecondPassed
#define I_DIAGLIB_F_GET_APP_IDENTIFIER             0x0034 // u32GetAppIdentifier
#define I_DIAGLIB_F_TIMEOUT_WORKER_THREAD          0x0035 // vTimeoutWorkerThread
#define I_DIAGLIB_F_TAKE_SEMAPHORE                 0x0036 // bTakeSemaphore
#define I_DIAGLIB_F_REL_SEMAPHORE                  0x0037 // vReleaseSemaphore
#define I_DIAGLIB_F_SPAWN_TIMEOUT_THREAD           0x0038 // vSpawnTimeoutThread
#define I_DIAGLIB_F_FILL_VEC_FROM_CCA_VL           0x0039 // vFillVectorFromCcaValueList
#define I_DIAGLIB_F_ON_GET_ROUTINE_RESULT          0x003a // vOnGetRoutineResult
#define I_DIAGLIB_F_ON_ROUTINE_CONTROL_ABORT       0x003b // vOnRoutineControlAbort
#define I_DIAGLIB_F_ON_ROUTINE_CONTROL_START       0x003c // vOnRoutineControlStart
#define I_DIAGLIB_F_SEND_ROUTINE_CTRL_ID_NOT_SUPP  0x003d // vSendRoutineCtrlIdNotSupported
#define I_DIAGLIB_F_GET_SERVICE_VERSION            0x003e // bGetServiceVersion
#define I_DIAGLIB_F_TRIGGER_TIMEOUT_THREAD         0x003f // vTriggerTimeoutThread
#define I_DIAGLIB_F_CHECK_PARAM_SIGNATURE          0x0040 // bCheckParameterSignature
#define I_DIAGLIB_F_CREATE_ERROR_VECTOR            0x0041 // oCreateErrorVector
#define I_DIAGLIB_F_SEND_MESSAGE                   0x0042 // bSendMessage
#define I_DIAGLIB_F_SEND_SYSTEMSET_CHECK_MR        0x0044 // bSendSystemSetCheckResult
#define I_DIAGLIB_F_ON_SYSTEMSET_CHECK             0x0045 // vOnSystemSetCheck
#define I_DIAGLIB_F_DECREASE                       0x0046 // vDecreaseUsers
#define I_DIAGLIB_F_INCREASE                       0x0047 // vIncreaseUsers
#define I_DIAGLIB_F_SEND_DIAGLIB_ERROR             0x0048 // bSendDiaglibError

// Info traces
#define I_DIAGLIB_CCA_FRAMEWORK_REQUESTED          0x0001 // CCA framework instance requested. Creating service handler.
#define I_DIAGLIB_CSFW_FRAMEWORK_REQUESTED         0x0002 // CSFW framework instance requested. Creating service handler.
#define I_DIAGLIB_FRAMEWORK_INSTANCE_DELETED       0x000f // Framework instance deleted.

#define I_DIAGLIB_DIAGNOSIS_INTERFACE_REQUESTED    0x0010 // Diagnosis Interface requested
#define I_DIAGLIB_CCA_INTERFACE_REQUESTED          0x0011 // CCA Interface requested
#define I_DIAGLIB_CSFW_INTERFACE_REQUESTED         0x0012 // CSFW Interface requested
#define I_DIAGLIB_SYSTEMSET_INTERFACE_REQUESTED    0x0013 // Systemset Interface requested
#define I_DIAGLIB_IOCTRL_INTERFACE_REQUESTED       0x0014 // IO control Interface requested
#define I_DIAGLIB_ROUTINECTRL_INTERFACE_REQUESTED  0x0015 // Routine control Interface requested
#define I_DIAGLIB_DIAGDATA_INTERFACE_REQUESTED     0x0016 // Diagnosis Data Interface requested

#define I_DIAGLIB_CREATED_REQUESTED_INTERFACE      0x0020 // Created requested interface.
#define I_DIAGLIB_CREATED_CTXT_FOR_ID              0x0021 // Created context for unique ID:
#define I_DIAGLIB_FOUND_CTXT_FOR_ID                0x0022 // Found context ID:
#define I_DIAGLIB_CREATED_CTXT_WITH_HANDLE         0x0023 // Created message context with handle:
#define I_DIAGLIB_GET_BACK_CTXT_FOR_HANDLE         0x0024 // Get back message context for handle:
#define I_DIAGLIB_MESSAGE_SEND_SUCCESSFUL          0x0025 // Sending message was successful
#define I_DIAGLIB_FORWARDING_MSG_WITH_CTXT         0x0026 // Forwarding incoming message to components Listener. Context:
#define I_DIAGLIB_FORWARDING_RSP_WITH_CTXT         0x0027 // Forwarding outgoing message to ServiceHandler. Context:
#define I_DIAGLIB_ADDED_LISTENER_ID                0x0028 // Added listener for the following unique ID:
#define I_DIAGLIB_ADDED_LISTENER_SYSSET_TYPE       0x0029 // Added listener for the following SystemSet Type:
#define I_DIAGLIB_SENDING_MESSAGE_ID               0x002a // Sending message with ID:
#define I_DIAGLIB_SENDING_MESSAGE_APPID            0x002b // Sending message from AppID:
#define I_DIAGLIB_RECEIVED_MESSAGE_ID              0x002c // Received message with unique ID:
#define I_DIAGLIB_RECEIVED_MESSAGE_APPID           0x002d // Received message in AppID:
#define I_DIAGLIB_INCOMING_MESSAGE_ADV_START       0x002e // ====================== INCOMING MESSAGE START ====================== AppId:
#define I_DIAGLIB_INCOMING_MESSAGE_ADV_STOP        0x002f // ====================== INCOMING MESSAGE STOP  ====================== AppId:
#define I_DIAGLIB_OUTGOING_MESSAGE_ADV_START       0x0030 // ====================== OUTGOING MESSAGE START ====================== AppId:
#define I_DIAGLIB_OUTGOING_MESSAGE_ADV_STOP        0x0031 // ====================== OUTGOING MESSAGE STOP  ====================== AppId:
#define I_DIAGLIB_APPLICATION_ID                   0x0032 // Application ID:

#define I_DIAGLIB_CONFLICTING_SEMAPHORE_CREATION   0x0041 // Conflict between two threads during creation of message context semaphore, no problem.
#define I_DIAGLIB_TOOK_SEAMAPHORE                  0x0042 // Successfully took semaphore.
#define I_DIAGLIB_REL_SEAMAPHORE                   0x0043 // Successfully released semaphore.
#define I_DIAGLIB_ENTER_CRITICAL_SECTION           0x0044 // === Entering critical section ===
#define I_DIAGLIB_LEAVE_CRITICAL_SECTION           0x0045 // === Leaving critical section ===
#define I_DIAGLIB_WORKER_SPAWNED_WITH_ID           0x0046 // Worker thread spawned with this ID:
#define I_DIAGLIB_DEF_FORWARD_MSG_WITH_CTXT        0x0047 // Forwarding incoming message to DEFAULT Listener. Context:
#define I_DIAGLIB_REC_SYSSET_REQ_DEFHANDLER        0x0048 // Default SystemSetHandler received a systemset request with ID:
#define I_DIAGLIB_REC_SYSSET_PREP_REQ_DEFHANDLER   0x0049 // Default SystemSetHandler received a systemset prepare request with ID:
#define I_DIAGLIB_REC_SYSSET_FINISH_REQ_DEFHANDLER 0x004a // Default SystemSetHandler received a systemset finished request with ID:
#define I_DIAGLIB_TYPE_OF_RECEIVED_SYSSET_REQUEST  0x004b // Type of received SystemSet request:
#define I_DIAGLIB_SENDING_POSITIVE_RESPONSE_SUC    0x004c // Sending of positive response suceeded:
#define I_DIAGLIB_ENTERED_NEW_STATE                0x004d // Entering new Application state:
#define I_DIAGLIB_SERVICE_AVAILABLE                0x004e // Diagnosis service available!
#define I_DIAGLIB_SERVICE_UNAVAILABLE              0x004f // Diagnosis service unavailable!

#define I_DIAGLIB_DEBUG_OUTPUT                     0x0050 // Debug output:
#define I_DIAGLIB_CREATE_CCA_SVC_HANDLER           0x0051 // Creating CCA Service handler.
#define I_DIAGLIB_MESSAGE_TIME_UNTIL_RESPONSE      0x0052 // Time between incoming message and response in ms:
#define I_DIAGLIB_DELETE_CCA_SVC_HANDLER           0x0053 // Deleted CCA Service handler.

#define I_DIAGLIB_MESSAGE_TYPE_ROUTINE_CTRL_MS     0x0060 // Message Type: RoutineControl->MethodStart
#define I_DIAGLIB_MESSAGE_TYPE_ROUTINE_CTRL_MA     0x0061 // Message Type: RoutineControl->MethodAbort
#define I_DIAGLIB_MESSAGE_TYPE_ROUTINE_CTRL_MR     0x0062 // Message Type: RoutineControl->MethodResult
#define I_DIAGLIB_MESSAGE_TYPE_GET_ROUTINE_RES_MS  0x0063 // Message Type: GetRoutineResult->MethodStart
#define I_DIAGLIB_MESSAGE_TYPE_GET_ROUTINE_RES_MR  0x0064 // Message Type: GetRoutineResult->MethodResult
#define I_DIAGLIB_MESSAGE_TYPE_SYSSET_PREPARE_MS   0x0065 // Message Type: SystemSetPrepare->MethodStart
#define I_DIAGLIB_MESSAGE_TYPE_SYSSET_PREPARE_MR   0x0066 // Message Type: SystemSetPrepare->MethodResult
#define I_DIAGLIB_MESSAGE_TYPE_SYSSET_FINISHED_MS  0x0067 // Message Type: SystemSetFinished->MethodStart
#define I_DIAGLIB_MESSAGE_TYPE_SYSSET_FINISHED_MR  0x0068 // Message Type: SystemSetFinished->MethodResult
#define I_DIAGLIB_MESSAGE_TYPE_SYSSET_MS           0x0069 // Message Type: SystemSet->MethodStart
#define I_DIAGLIB_MESSAGE_TYPE_SYSSET_MR           0x006a // Message Type: SystemSet->MethodResult

#define I_DIAGLIB_READ_PRIO_FROM_REG               0x0070 // Read worker thread priority from registry:
#define I_DIAGLIB_READ_STCK_FROM_REG               0x0071 // Read worker thread stack-size from registry:
#define I_DIAGLIB_TIMER_DEACTIVATED                0x0072 // Timeout timer deactivated because map is empty
#define I_DIAGLIB_TIMER_ACTIVATED                  0x0073 // Timeout timer activated because map has entries

#define I_DIAGLIB_USER_GONE                        0x0075 // A user deleted its framework. Users now:
#define I_DIAGLIB_NEW_USER                         0x0076 // A user created its framework. Users now:

// will result in DIAGLIB Flow: <--- className:functionName
//                          or: ---> className:functionName

#define I_DIA_DEFSET_TRACE                                     0xFFFF // TRACE
#ifndef TSH_TP
   #define TSH_TP(a)        ET_TRACE_INFO_BIN(TR_CLASS_DIAGLIB_TSH_TP, ET_EN_T16 _ I_DIA_DEFSET_TRACE _ ET_EN_T32 _ a _ ET_EN_DONE);
#endif


#define DIAGLIB_TRACE_FLOW_E(u8Lvl, u16FuncId)        DIAGLIB_TRACE_I                              \
                                                   ( (tU16)TR_CLASS_DIAGLIB_FLOW,                  \
                                                     ET_EN_T8 _ (tU8)I_DIAGLIB_TRACEFLOW_ENTRY _   \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ u8Lvl _                            \
                                                     ET_EN_T16 _ u16FuncId _                       \
                                                     ET_EN_DONE  )

#define DIAGLIB_TRACE_FLOW_L(u8Lvl, u16FuncId)        DIAGLIB_TRACE_I                              \
                                                   ( (tU16)TR_CLASS_DIAGLIB_FLOW,                  \
                                                     ET_EN_T8 _ (tU8)I_DIAGLIB_TRACEFLOW_LEAVE _   \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ u8Lvl _                            \
                                                     ET_EN_T16 _ u16FuncId _                       \
                                                     ET_EN_DONE  )

// will result in Traceclass: fileName.(lineNr) -> <Cleartext of message>
#define DIAGLIB_TRACE_INFO(u16ClassId, u16InfoId) DIAGLIB_TRACE_I                                  \
                                                   ( u16ClassId,                                   \
                                                     ET_EN_T8 _ (tU8)I_DIAGLIB_INFO _              \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ diaglib_FuncTrace::u8GetLvl()+1 _  \
                                                     ET_EN_T16 _ (tU16)__LINE__ _                  \
                                                     ET_EN_T16 _ u16InfoId _                       \
                                                     ET_EN_DONE )

#define DIAGLIB_TRACE_WARN(u16ClassId, u16WarnId) DIAGLIB_TRACE_W                                  \
                                                   ( u16ClassId,                                   \
                                                     ET_EN_T8 _ (tU8)W_DIAGLIB_SIMPLE_WARN _       \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ diaglib_FuncTrace::u8GetLvl()+1 _  \
                                                     ET_EN_T16 _ (tU16)__LINE__ _                  \
                                                     ET_EN_T16 _ u16WarnId _                       \
                                                     ET_EN_DONE )

#define DIAGLIB_TRACE_ERROR(u16ClassId, u16ErrId) DIAGLIB_TRACE_E                                  \
                                                   ( u16ClassId,                                   \
                                                     ET_EN_T8 _ (tU8)E_DIAGLIB_SIMPLE_ERROR _      \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ diaglib_FuncTrace::u8GetLvl()+1 _  \
                                                     ET_EN_T16 _ (tU16)__LINE__ _                  \
                                                     ET_EN_T16 _ u16ErrId _                        \
                                                     ET_EN_DONE )

// will result in Traceclass: fileName.(lineNr) -> <Cleartext of message> <u32Value>
#define DIAGLIB_TRACE_INFO_U32(u16ClassId, u16InfoId, u32Value) DIAGLIB_TRACE_I                    \
                                                   ( u16ClassId,                                   \
                                                     ET_EN_T8 _ (tU8)I_DIAGLIB_U32_INFO _          \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ diaglib_FuncTrace::u8GetLvl()+1 _  \
                                                     ET_EN_T16 _ (tU16)__LINE__ _                  \
                                                     ET_EN_T16 _ u16InfoId _                       \
                                                     ET_EN_T32 _ u32Value _                        \
                                                     ET_EN_DONE )

#define DIAGLIB_TRACE_WARN_U32(u16ClassId, u16InfoId, u32Value) DIAGLIB_TRACE_W                    \
                                                   ( u16ClassId,                                   \
                                                     ET_EN_T8 _ (tU8)W_DIAGLIB_U32_WARN _          \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ diaglib_FuncTrace::u8GetLvl()+1 _  \
                                                     ET_EN_T16 _ (tU16)__LINE__ _                  \
                                                     ET_EN_T16 _ u16InfoId _                       \
                                                     ET_EN_T32 _ u32Value _                        \
                                                     ET_EN_DONE )

#define DIAGLIB_TRACE_ERROR_U32(u16ClassId, u16InfoId, u32Value) DIAGLIB_TRACE_E                   \
                                                   ( u16ClassId,                                   \
                                                     ET_EN_T8 _ (tU8)E_DIAGLIB_U32_ERROR _         \
                                                     ET_EN_T8 _ (tU8)DIAGLIB_FILE_NUMBER _         \
                                                     ET_EN_T8 _ diaglib_FuncTrace::u8GetLvl()+1 _  \
                                                     ET_EN_T16 _ (tU16)__LINE__ _                  \
                                                     ET_EN_T16 _ u16InfoId _                       \
                                                     ET_EN_T32 _ u32Value _                        \
                                                     ET_EN_DONE )

class diaglib_FuncTrace
{
public:
   diaglib_FuncTrace(tU16 u16FuncId)
   {
      mu16FuncId = u16FuncId;
      ++mu8InstanceCounter;
      DIAGLIB_TRACE_FLOW_E(mu8InstanceCounter, mu16FuncId);
   }

   ~diaglib_FuncTrace()
   {
      DIAGLIB_TRACE_FLOW_L(mu8InstanceCounter, mu16FuncId);
      --mu8InstanceCounter;
   }

   inline static tU8 u8GetLvl()
   {
      return mu8InstanceCounter;
   }

protected:
   diaglib_FuncTrace(): mu16FuncId(0) {}
   static tU8 mu8InstanceCounter; // Initialized with zero in tclDiagnosisInterfaceFactory.cpp
   tU16 mu16FuncId;
};

#endif   // DIAGLIB_TRACE_H
