/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Service Handler CCA - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_SERVICE_HANDLER_CCA
#define DIAGLIB_SERVICE_HANDLER_CCA



#ifndef __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define  AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h" // use application help library
#endif


class midw_fi_tcl_ValueList; //lint !e763
class fi_tclVisitorMessage; //lint !e763
class midw_fi_tcl_ValueUnion; //lint !e763

#include "../tclServiceHandler.h"

namespace diaglib {

class tclMessageContextCCA; //lint !e763


class tclServiceHandlerCCA : public tclServiceHandler,
                                     public ahl_tclBaseWork
{
private:
   ail_tclAppInterfaceRestricted* poGWMain;         // Pointer on cca application

   tU16                           u16OurAppId;
   tclIoControlListenerIF*        poIoControlListener;
   tclRoutineControlListenerIF*   poRoutineControlListener;
   tclDiagnosisDataListenerIF*    poDiagDataListener;
   tclSystemSetListenerIF*        poSystemSetListener;

   // Todo: Clarify diag_tclTraceChannel*      _poTrace;         // handler to trace

   tVoid vSendError ( const amt_tclServiceData* poMessage, tU16 u16ErrorCode );

   tBool bSendMessage(amt_tclServiceData& oMsg);
protected:
   virtual tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage);

public:
   tclServiceHandlerCCA(); // Not implemented, do not use!
   tclServiceHandlerCCA(tVoid*);
   virtual ~tclServiceHandlerCCA();

   virtual tBool bSendSystemSetMethodResult (
                                              tenSystemSetResult,
                                              const tclParameterVector&,
                                              tContext context
                                            );

   virtual tBool bSendSystemSetPrepareMethodResult (
                                                     tenSystemSetResult,
                                                     const tclParameterVector&,
                                                     tContext context
                                                   );

   virtual tBool bSendSystemSetFinishedMethodResult (
                                                      tContext context
                                                    );

   virtual tBool bSendSystemSetCheckResult (
                                             tenSystemSetResult enSystemSetResult,
                                             const tclParameterVector& oValueList,
                                             tContext MsgContext
                                           );

   virtual tBool bSendDiagnosisDataResult (
                                                  tenDiagDataResult enReadResult,
                                                  const tclParameterVector& oReadValues,
                                                  tContext context
                                                );

   virtual tBool bSendIoCtrlMethodResult (
                                              tenIoCtrlResult enIoResult,
                                              tenIoControlAction enAction,
                                              const tclParameterVector& oResultList,
                                              tContext context
                                            );

   virtual tBool bSendIoCtrlFreezeResult   (
                                              tenIoCtrlResult enIoResult,
                                              tContext MsgContext
                                           );

   virtual tBool bSendIoCtrlUnfreezeResult   (
                                                 tenIoCtrlResult enIoResult,
                                                 tContext MsgContext
                                              ) ;

   virtual tBool bSendRoutineCtrlMethodResult (
                                                tenRoutineCtrlResult enRoutineStatus,
                                                const tclParameterVector& oRoutineResult,
                                                tContext context
                                              );

   virtual tBool bSendGetRoutineResultMethodResult (
                                                     tenRoutineCtrlResult enRoutineStatus,
                                                     const tclParameterVector& oRoutineResult,
                                                     tContext context
                                                   );

   virtual tU32 u32GetAppIdentifier();

   /**
    * Listener registration functions
    */

   virtual tVoid vRegisterSystemSetListener      (
                                                   tclSystemSetListenerIF* poListener
                                                 );

   virtual tVoid vRegisterDiagDataListener       (
                                                   tclDiagnosisDataListenerIF* poListener
                                                 );

   virtual tVoid vRegisterRoutineControlListener (
                                                   tclRoutineControlListenerIF* poListener
                                                 );

   virtual tVoid vRegisterIoControlListener      (
                                                   tclIoControlListenerIF* poListener
                                                 );

   virtual tVoid vRegisterDiagnosisDataListener  (
                                                   tclDiagnosisDataListenerIF* poListener
                                                 );

   /**
    * CCA service functions
    */
   virtual tVoid vSetApplication(ail_tclIAppAdapt* poApp);
   virtual tU16 u16GetServiceId();

   virtual tVoid vOnNewAppState(tU32 u32OldState, tU32 u32NewState);

   virtual tVoid vOnServiceState(tU16, tU16, tU16, tU8, tU16);

   tBool bGetServiceVersion ( tU16& rfu16MajorVersion,
                              tU16& rfu16MinorVersion,
                              tU16& rfu16PatchVersion) const;

   /**
    * CCA message handling functions
    */

   tVoid vHandleRoutineControl     ( amt_tclServiceData* poMessage );
   tVoid vHandleGetRoutineResult   ( amt_tclServiceData* poMessage );
   tVoid vHandleIOControl          ( amt_tclServiceData* poMessage );
   tVoid vHandleSystemSetPrepare   ( amt_tclServiceData* poMessage );
   tVoid vHandleSystemSetFinished  ( amt_tclServiceData* poMessage );
   tVoid vHandleSystemSet          ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagnosisData      ( amt_tclServiceData* poMessage );

   DECLARE_MSG_MAP(tclServiceHandlerCCA)

};

}
#endif // DIAGLIB_SERVICE_HANDLER_CCA


