/**************************************************************************//**
* \file           tclServiceDiaglib.h
* \author         AI/PJ-FO45 - Evers
* \date           2010-08-04
*
* \brief Service Handler - Diagnosis Library (diaglib)
*
* (c) 2010 Bosch Car Multimedia GmbH
*//****************************************************************************/
#ifndef DIAGLIB_SERVICE_DIAGLIB
#define DIAGLIB_SERVICE_DIAGLIB

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define  AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h" // use application help library
#endif

namespace diaglib {

class tclSystemSetIF;
class tclRoutineControlIF;
class tclIoControlIF;
class tclDiagnosisDataIF;
class tclCCAServiceIF;
class tclDiagnosisIF;                           //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol


class tclServiceDiaglibOneThread;
class tclServiceDiaglibTwoThread;

#ifdef DIAGLIG_USE_TWO_TREAD_APP
typedef tclServiceDiaglibTwoThread tclServiceDiaglib;
#else
typedef tclServiceDiaglibOneThread tclServiceDiaglib;
#endif


class tclServiceDiaglibOneThread : public ahl_tclBaseOneThreadService
{
public:

    tclServiceDiaglibOneThread();
    tclServiceDiaglibOneThread(ahl_tclBaseOneThreadApp* poMain, tU8 u8ExpectedMajorDiaglibVer);
    virtual ~tclServiceDiaglibOneThread();

   tclSystemSetIF*      poGetSysSet();
   tclRoutineControlIF* poGetRoutineCtrl();
   tclIoControlIF*      poGetIoCtrl();
   tclDiagnosisDataIF*  poGetDiagData();

protected:

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
    virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
    tVoid vHandleAllMessages(amt_tclServiceData* poMessage);

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
    DECLARE_MSG_MAP(tclServiceDiaglibOneThread)

private:
   tclDiagnosisIF*      _poDiagIF;
   tclCCAServiceIF*     _poCcaIF;

   // +++ Interfaces you need +++
   tclSystemSetIF*      _poSysSetIF;
   tclRoutineControlIF* _poRoutineCtrlIF;
   tclIoControlIF*      _poIoCtrlIF;
   tclDiagnosisDataIF*  _poDiagDataIF;
};


class tclServiceDiaglibTwoThread : public ahl_tclBaseTwoThreadService
{
public:

    tclServiceDiaglibTwoThread();
    tclServiceDiaglibTwoThread(ahl_tclBaseTwoThreadApp* poMain, tU8 u8ExpectedMajorDiaglibVer);
    virtual ~tclServiceDiaglibTwoThread();

   tclSystemSetIF*      poGetSysSet();
   tclRoutineControlIF* poGetRoutineCtrl();
   tclIoControlIF*      poGetIoCtrl();
   tclDiagnosisDataIF*  poGetDiagData();



protected:

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
    virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);


    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
    tVoid vHandleAllMessages(amt_tclServiceData* poMessage);

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
    DECLARE_MSG_MAP(tclServiceDiaglibTwoThread)

private:
   tclDiagnosisIF*      _poDiagIF;
   tclCCAServiceIF*     _poCcaIF;

   // +++ Interfaces you need +++
   tclSystemSetIF*      _poSysSetIF;
   tclRoutineControlIF* _poRoutineCtrlIF;
   tclIoControlIF*      _poIoCtrlIF;
   tclDiagnosisDataIF*  _poDiagDataIF;
};


}
#endif // DIAGLIB_SERVICE_DIAGLIB
