/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Message Context CCA - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_MESSAGE_CONTEXT_CCA_H
#define DIAGLIB_MESSAGE_CONTEXT_CCA_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#include "../tclMessageContext.h"

class amt_tclServiceData; //lint !e763

namespace diaglib {

class tclMessageContextCCA : public tclMessageContext
{
protected:
   tU16 u16SenderAppId;
   tU16 u16ServiceId;
   tU16 u16CmdCounter;
   tU16 u16FunctionId;
   tU16 u16RegisterId;

   tclMessageContextCCA(): // Don't use!
      u16SenderAppId(0),
      u16ServiceId(0),
      u16CmdCounter(0),
      u16FunctionId(0),
      u16RegisterId(0) {}

public:
   tclMessageContextCCA (
                                  const amt_tclServiceData* poMessage,
                                  tclMessageContext::ten_MessageGroup enGroup,
                                  tU32 u32Id,
                                  tU32 u32AdditionalValue = 0
                                );
   virtual ~tclMessageContextCCA();

   tU16 u16GetSenderAppId() const;
   tU16 u16GetServiceId() const;
   tU16 u16GetCmdCounter() const;
   tU16 u16GetFunctionId() const;
   tU16 u16GetRegisterId() const;

};
}
#endif // DIAGLIB_MESSAGE_CONTEXT_CCA_H


