/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Message Context CCA - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_MESSAGE_CONTEXT_CCA

#ifndef __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define  AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h" // use application help library
#endif

#include "tclMessageContextCCA.h"


#include "../Trace.h"

// No flow tracing in this file by purpose.

namespace diaglib {

/***********************************************************************//**
 * \brief Constructor
 *
 * Initializes all members and subclass.
 *
 * \param[in] poMessage Incoming CCA message to create context for
 * \param[in] enGroup Message group
 * \param[in] u32Id Unique ID of message
 * \param[in] u32AdditionalValue Additional value used for some groups
 * 
 * \return n/a
 *//************************************************************************/
tclMessageContextCCA::tclMessageContextCCA ( 
                                  const amt_tclServiceData* poMessage, 
                                  tclMessageContext::ten_MessageGroup enGroup, 
                                  tU32 u32Id, 
                                  tU32 u32AdditionalValue
                                  ): tclMessageContext (
                                       enGroup,
                                       u32Id,
                                       u32AdditionalValue
                                       )

{
   if(OSAL_NULL == poMessage)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      bValid = false;
      u16SenderAppId = 0;
      u16ServiceId = 0;
      u16CmdCounter = 0;
      u16FunctionId = 0;
      u16RegisterId = 0;
   }
   else
   {
      bValid = true;
      u16SenderAppId = poMessage->u16GetSourceAppID();
      u16ServiceId = poMessage->u16GetServiceID();
      u16CmdCounter = poMessage->u16GetCmdCounter();
      u16FunctionId = poMessage->u16GetFunctionID();
      u16RegisterId = poMessage->u16GetRegisterID();
   }
}

/***********************************************************************//**
 * \brief Denstructor
 *
 * \return n/a
 *//************************************************************************/
tclMessageContextCCA::~tclMessageContextCCA()
{

}

/***********************************************************************//**
 * \brief Returns the senders Application ID
 *
 * Returns the senders Application ID
 * 
 * \return tU16 Senders Application ID
 *//************************************************************************/
tU16 tclMessageContextCCA::u16GetSenderAppId() const
{
   if(false == bValid)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_REQUEST_INVALID_CTXT);
      return 0;
   }

   return u16SenderAppId;
}

/***********************************************************************//**
 * \brief Returns the Service ID
 *
 * Returns the Service ID
 * 
 * \return tU16 Service ID
 *//************************************************************************/
tU16 tclMessageContextCCA::u16GetServiceId() const
{
   if(false == bValid)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_REQUEST_INVALID_CTXT);
      return 0;
   }
   return u16ServiceId;
}

/***********************************************************************//**
 * \brief Returns the Command Counter of incoming message
 *
 * Returns the Command Counter of incoming message
 * 
 * \return tU16 Command Counter of incoming message
 *//************************************************************************/
tU16 tclMessageContextCCA::u16GetCmdCounter() const
{
   if(false == bValid)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_REQUEST_INVALID_CTXT);
      return 0;
   }
   return u16CmdCounter;
}

/***********************************************************************//**
 * \brief Returns the Function ID
 *
 * Returns the Function ID
 * 
 * \return tU16 Function ID
 *//************************************************************************/
tU16 tclMessageContextCCA::u16GetFunctionId() const
{
   if(false == bValid)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_REQUEST_INVALID_CTXT);
      return 0;
   }
   return u16FunctionId;
}

/***********************************************************************//**
 * \brief Returns the register ID
 *
 * Returns the Register ID
 * 
 * \return tU16 Register ID
 *//************************************************************************/
tU16 tclMessageContextCCA::u16GetRegisterId() const
{
   if(false == bValid)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_REQUEST_INVALID_CTXT);
      return 0;
   }

   return u16RegisterId;
}

}
