/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Service Handler CCA - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif

#ifndef __INCLUDED_DIAGLIB_COMMON__
#define __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#define DIAGLIB_FILE_NUMBER F_DIAGLIB_CCA_SERVICE_HANDLER

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


// MIDW_FI DEFINES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS

// FI DEFINES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

// If the Service ID is not defined in ccaservice.h use the default one
#ifndef CCA_C_U16_SRV_DIAGLIB
#define CCA_C_U16_SRV_DIAGLIB 0x0071
#endif

#include "tclCCAHelper.h"
#include "../Enumerations.h"
#include "tclServiceHandlerCCA.h"
#include "../tclMessageContextManager.h"
#include "tclMessageContextCCA.h"
#include "../tclDiagnosisDataListenerIF.h"

#include "../Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_DIAGNOSISDATA
#include "trcGenProj/Header/tclDiagnosisDataCCA.cpp.trc.h"
#endif

namespace diaglib {


/***********************************************************************//**
 * \brief Send routine control MethodResult Message
 *
 * Construct and send CCA message by doing the following steps:
 * \li Retrieve the message context using the provided Context pointer
 * \li Extract messaging data out of the MessageContext
 * \li Convert diaglib internal types to CCA specific midw_fi types
 * \li Put everything into a CCA message object
 * \li Send it using the application message send functionality
 * As there is no need to report success or failure on a finish message, only
 * the MessageContext handle is a parameter to this message.
 *
 * \param[in] enReadResult - Status of reat request
 * \param[in] oValues - Result list of read or error code
 * \param[in] poMessageContext - MessageContext handle of incoming message
 *
 * \return  boolean if sending of response was successful or failed
 *//************************************************************************/
tBool tclServiceHandlerCCA::bSendDiagnosisDataResult (
                                                              tenDiagDataResult enReadResult, 
                                                              const tclParameterVector& oValues,
                                                              tContext context
                                                           )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::bSendDiagnosisDataResult"));

   midw_diaglibfi_tclMsgDiagnosisDataStatus oResult;
   fi_tclVisitorMessage* poResultMsg = OSAL_NULL;

   tclMessageContextCCA* poMessageContextCca = OSAL_NULL;
   tBool bResult = TRUE;
  
   if( 
       tclMessageContextManager::bGetContextBack<tclMessageContextCCA>(context, &poMessageContextCca) == FALSE || 
       tclMessageContext::EN_MESSAGE_DIAG_DATA != poMessageContextCca->getMessageGroup() 
     )   
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendDiagnosisDataResult => ERROR: CANT_SEND_MSG_DUE_TO_CTXT"));
      bResult = FALSE;
   }
   else
   {
      // Fill the CCA result message
      if(poMessageContextCca->u16GetFunctionId() == MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA)
      {
         oResult.DiagnosisDataId                = poMessageContextCca->getId();
         oResult.DiagnosisDataResult.enType     = static_cast<midw_fi_tcl_e8_DiagDataResult::tenType>(enReadResult);
         tclCCAHelper::vFillCcaValueListFromVector(oValues, oResult.DiagnosisDataValues );

         poResultMsg = OSAL_NEW fi_tclVisitorMessage( oResult );
      }
      else
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendDiagnosisDataResult => ERROR: u16GetFunctionId invalid"));
         bResult = FALSE;
      }
      
      if(OSAL_NULL == poResultMsg)
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendDiagnosisDataResult => ERROR: OSAL_NULL == poResultMsg"));
         FATAL_M_ASSERT_ALWAYS();
         bResult = FALSE; // lint sucks
      }

      if(bResult == TRUE && poResultMsg != OSAL_NULL)
      {
         tclCCAHelper::vInitPrpertyStatusServiceData((*poResultMsg), poMessageContextCca, u16OurAppId);
         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::bSendDiagnosisDataResult => MsgId:%d AppId:%d",poMessageContextCca->getId(),static_cast<tU32>(u16OurAppId)));
         bResult = bSendMessage((*poResultMsg));
      }
      else
      {
         bResult = FALSE;
      }
   }

   if(OSAL_NULL != poResultMsg)
      OSAL_DELETE poResultMsg;

   if(OSAL_NULL != poMessageContextCca)
      OSAL_DELETE poMessageContextCca;
   

   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::bSendDiagnosisDataResult"));

   return bResult;
}

/***********************************************************************//**
 * \brief Register the routine control listener
 *
 * Register the pointer to the diaglib INTERNAL listener for routine control
 * requests.
 *
 * \param[in] poListener - Pointer to Listener
 *
 * \return none
 *//************************************************************************/
tVoid tclServiceHandlerCCA::vRegisterDiagnosisDataListener ( 
                                                               tclDiagnosisDataListenerIF* poListener
                                                           )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::vRegisterDiagnosisDataListener"));
   if(OSAL_NULL == poListener)
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vRegisterDiagnosisDataListener => ERROR: OSAL_NULL == poListener"));
      return;
   }

   poDiagDataListener = poListener;
   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::vRegisterDiagnosisDataListener"));
   
}

/***********************************************************************//**
 * \brief Handles incoming Routine Control messages
 *
 * On incoming request the following steps are executed
 * \li Check whether Message and registered listener are valid
 * \li On correct OpCode use midw_fi types to extract payload
 * \li Convert message payload to diaglib internal types
 * \li Create a message context to be able to send back a response
 * \li Call the registered listener using diaglib internal types
 *
 * \param[in] poMessage The incoming message
 *
 * \todo Implement!
 *
 * \return none
 *//************************************************************************/
tVoid tclServiceHandlerCCA::vHandleDiagnosisData     ( amt_tclServiceData* poMessage )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::vHandleDiagnosisData"));

   if(OSAL_NULL == poMessage )
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vHandleDiagnosisData => ERROR: OSAL_NULL == poMessage"));
      return;
   }
   else if(OSAL_NULL == poDiagDataListener)
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vHandleDiagnosisData => ERROR: OSAL_NULL == poDiagDataListener"));
      return;
   }
   tclMessageContextCCA* poMsgContext;
   tclParameterVector oParameters;
   oParameters.clear();   
   tContext context;

   switch (poMessage->u8GetOpCode())
   {
      case AMT_C_U8_CCAMSG_OPCODE_SET:
      {
         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleDiagnosisData => u8GetOpCode = AMT_C_U8_CCAMSG_OPCODE_SET"));
         midw_diaglibfi_tclMsgDiagnosisDataSet oMsgData;
         // Create concrete msg object
         fi_tclVisitorMessage oMsg( poMessage );
         if (oMsg.s32GetData(oMsgData) == OSAL_ERROR)
         {
            NORMAL_M_ASSERT_ALWAYS ();
         }
         // Cast CCA types to internal types
         tclCCAHelper::vFillVectorFromCcaValueList(oMsgData.DiagnosisWriteValues, oParameters);


         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleDiagnosisData => MsgDataId:%d AppId:%d",oMsgData.DiagnosisDataId,static_cast<tU32>(u16OurAppId) ));


         // Create Message context and store it in MessageContext Manager
         poMsgContext = OSAL_NEW tclMessageContextCCA( 
                                                   poMessage, 
                                                   tclMessageContext::EN_MESSAGE_DIAG_DATA,
                                                   oMsgData.DiagnosisDataId
                                                );

         context = tclMessageContextManager::poAddContext(poMsgContext);
         poDiagDataListener->vOnDiagnosisDataWrite (
                                                               oMsgData.DiagnosisDataId,
                                                               oParameters,
                                                               context
                                                            );
         break;
      }
      case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleDiagnosisData => u8GetOpCode = AMT_C_U8_CCAMSG_OPCODE_GET"));
         midw_diaglibfi_tclMsgDiagnosisReadMethodStart oMsgData;
         // Create concrete msg object
         fi_tclVisitorMessage oMsg( poMessage );
         if (oMsg.s32GetData(oMsgData) == OSAL_ERROR)
         {
            NORMAL_M_ASSERT_ALWAYS ();
         }

         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleDiagnosisData => MsgDataId:%d AppId:%d",oMsgData.DiagnosisDataId,static_cast<tU32>(u16OurAppId) ));


         // Create Message context and store it in MessageContext Manager
         poMsgContext = OSAL_NEW tclMessageContextCCA( 
                                                   poMessage, 
                                                   tclMessageContext::EN_MESSAGE_DIAG_DATA,
                                                   oMsgData.DiagnosisDataId
                                                );

         context = tclMessageContextManager::poAddContext(poMsgContext);
         poDiagDataListener->vOnDiagnosisDataRead(
                                                            oMsgData.DiagnosisDataId,
                                                            context
                                                          );
         break;
      }

      default:
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vHandleDiagnosisData => ERROR: u8GetOpCode %d unkwonw",poMessage->u8GetOpCode()));
         vSendError ( poMessage, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
         break;
      }
   }

   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::vHandleDiagnosisData"));
   return;
}




}// namespace diaglib {
