#ifndef DIA_TCLFUNCTOR_H
#define DIA_TCLFUNCTOR_H

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

enum tenNotificationMode
{
    //! the notification will be issued only for the first time,
    //! after that the functor is removed from notification list and the memory is freed
    enSingleShot = 0,
    //! whenever the condition is met a notification is sent to the client.
    //! The responsibility of unregisteriring and deleting the functor lies with the client itself
    enContinuous
};

class dia_tclFunctor
{
public:
    dia_tclFunctor(tenNotificationMode mMode)
                  : mNotificationMode(mMode)
    {};
    virtual tVoid operator()()=0;
    virtual tBool bIsSingleShot()
    {
        return (mNotificationMode == enSingleShot);

    };
    virtual ~dia_tclFunctor()
    {};

protected:
    //! deprecated default constructor without implementation
    dia_tclFunctor ( tVoid );

private:
    //! notification mode
    tenNotificationMode mNotificationMode;

};



// derived template class
template <class TClass> class dia_tclFunctorImpl : public dia_tclFunctor
{
    typedef tVoid (TClass::*tfptr)(tVoid*,dia_tclFunctor*) const;

public:
    //! constructor - takes pointer to an object and pointer to a member function
    //! and an enum which specifies if the callback is a singleshot or not
    dia_tclFunctorImpl(TClass* _pObj, tfptr _fpt,tVoid* _pArg,tenNotificationMode mMode)
                    :dia_tclFunctor( mMode),
                    pObj(_pObj),
                    fpt(_fpt),
                    pArg(_pArg)
    {};

    virtual ~dia_tclFunctorImpl()
    {
        //to make sure that the object is deleted!
        dia_tclFnctTrace oTrace("~dia_tclFunctorImpl");
    };
    //! override operator "()"
    virtual tVoid operator()()
    {
        //! execute member function with the stored argument and a pointer to self
        (*pObj.*fpt)(pArg,this);

    };

protected:
    //! deprecated default constructor without implementation
    dia_tclFunctorImpl ( tVoid );

private:
    //! pointer to object
    TClass* pObj;
    //! function pointer
    tfptr fpt;
    //! argument which has to be passed when calling the function
    tVoid* pArg;
};


#endif /*DIA_TCLFUNCTOR_H*/

