/*
 * dia_tclDiagSessionBody.h
 *
 *  Created on: 11.08.2009
 *      Author: gib2hi
 */

#ifndef DIA_TCLDIAGSESSIONBODYUDS_H_
#define DIA_TCLDIAGSESSIONBODYUDS_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

#include "common/framework/fsm/generated/dia_EngineUdsFSM.h"

class dia_tclDiagSessionUds;

class dia_tclDiagSessionBodyUds
    : protected dia_EngineUdsFSM::FsmBehaviour
{

   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclDiagSessionBodyUds);

public:
    //! singleton constructor
    static dia_tclDiagSessionBodyUds* getInstance ( void );
    //! singleton destructor
    static void deleteInstance ( void );

protected:
    // FSM actions
    virtual void vFsmAdoptRequest ( void* pArg );
    virtual void vFsmCleanupProcessing ( void* pArg );
    virtual void vFsmConfirmationTimeout ( void* pArg );
    virtual void vFsmDispatchInternalMsg ( void* pArg );
    virtual void vFsmIgnoreRequest ( void* pArg );
    virtual void vFsmInitRx ( void* pArg );
    virtual void vFsmPostProcessingTimeout ( void* pArg );
    virtual void vFsmPrepareProcessing ( void* pArg );
    virtual void vFsmProcessingTimeout ( void* pArg );
    virtual void vFsmResetRx ( void* pArg );
    virtual void vFsmSendConfirmation ( void* pArg );
    virtual void vFsmSetDiagActive ( void* pArg );
    virtual void vFsmSetDiagInactive ( void* pArg );
    virtual void vFsmStartConfirmationTimer ( void* pArg );
    virtual void vFsmStartPostProcessing ( void* pArg );
    virtual void vFsmStartPostProcessingTimer ( void* pArg );
    virtual void vFsmStartProcessing ( void* pArg );
    virtual void vFsmStartProcessingTimer ( void* pArg );
    virtual void vFsmStartTests ( void* pArg );
    virtual void vFsmStopConfirmationTimer ( void* pArg );
    virtual void vFsmStopPostProcessingTimer ( void* pArg );
    virtual void vFsmStopProcessingTimer ( void* pArg );
    virtual void vFsmValidateRequest ( void* pArg );

    // FSM guard conditions
    virtual bool bFsmIsServiceAccepted ( void* pArg );
    virtual bool bFsmIsServiceInternal ( void* pArg );

protected:
    //! constructor
    dia_tclDiagSessionBodyUds ( void );
    //! destructor
    virtual ~dia_tclDiagSessionBodyUds ( void );

public:
    void vAcceptEvent ( const dia_tclDiagSession::tclEvent& oEvent );

    void vInit ( void );

private:

    //! singleton constructor
    static dia_tclDiagSessionBodyUds* mpInstance;
    //! pointer to the corresponding session object (is a singleton as well)
    static dia_tclDiagSessionUds* mpSession;

    //! pointer to the FSM object
    dia_EngineUdsFSM::Fsm* mpFSM;

    bool mIsRequestAccepted;
};

#endif /* DIA_TCLDIAGSESSIONBODY_H_ */
