/*
 * dia_tclDiagSessionBody.cpp
 *
 *  Created on: 11.08.2009
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#include "common/depricated/dia_tclDiagSessionUds.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_MANAGER__
#include "common/framework/security/dia_SecurityManager.h"
#endif

#ifndef __INCLUDED_DIA_CMD_SET_DIAG_ACTIVITY
#include "common/framework/application/dia_CmdSetDiagActivity.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_RUNLEVEL__
#include "common/framework/application/dia_PredicateRunlevel.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_REGISTRATION_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceRegistrationCCA.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_STATE_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceStateCCA.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND__
#include "common/framework/application/dia_Command.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include "common/framework/application/dia_CommandController.h"
#endif

#ifndef __INCLUDED_DIA_NRC_GENERATOR__
#include <common/services/uds/generic/dia_NRCGenerator.h>
#endif

#ifndef CCASERVICE_HEADER
#include "../../../../di_frameworks/components/cca/ccaservice.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_WRAPPER__
#include "common/framework/engine/dia_ServiceHandlerWrapper.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#include "common/depricated/dia_tclDiagSessionBodyUds.h"

dia_tclDiagSessionBodyUds*
dia_tclDiagSessionBodyUds::mpInstance = 0;
dia_tclDiagSessionUds*
dia_tclDiagSessionBodyUds::mpSession  = 0;

#define MAX_TIME_WAIT_CONF_AND_QUIT         600 // [ms] timeout for WaitConfAndQuit state
#define MAX_TIME_DIAG_ACTIVITY             1000 // [ms] timeout for WaitConfAndQuit state

using namespace dia_EngineUdsFSM;

//-----------------------------------------------------------------------------

dia_tclDiagSessionBodyUds*
dia_tclDiagSessionBodyUds::getInstance()
{
   if (!mpInstance)
   {
      dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::getInstance()");
      mpInstance = OSAL_NEW dia_tclDiagSessionBodyUds;
   }

   return mpInstance;
}

void
dia_tclDiagSessionBodyUds::deleteInstance ( void )
{
   if ( mpInstance )
   {
      dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::deleteInstance()");
      OSAL_DELETE mpInstance;
      mpInstance = 0;
   }
}
//-----------------------------------------------------------------------------

dia_tclDiagSessionBodyUds::dia_tclDiagSessionBodyUds ( void )
   : mpFSM(0),
     mIsRequestAccepted(false)
{
   dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::dia_tclDiagSessionBodyUds()");
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vInit ( void )
{
    dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::vInit()");

    mpSession = getInstanceOfDiagSessionUDS();

    // create the state machine object
    mpFSM = OSAL_NEW dia_EngineUdsFSM::Fsm(this);

    if ( mpFSM )
    {
        DIA_TR_INF( "### Initializing State Machine ###");
        mpFSM->init();
        DIA_TR_INF( "### Done ###");
    }
}

//-----------------------------------------------------------------------------

dia_tclDiagSessionBodyUds::~dia_tclDiagSessionBodyUds ( void )
{
#ifdef  __DIA_UNIT_TESTING__
    dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::~dia_tclDiagSessionBodyUds()");
#endif

   // destructors should not throw exceptions (--> lint), but functions called in the
   // could possibly throw excepections. So we catch them here and raise an assert
   _BP_TRY_BEGIN
   {
      OSAL_DELETE mpFSM;
      mpFSM = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_tclDiagSessionBodyUds::~dia_tclDiagSessionBodyUds !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

bool
dia_tclDiagSessionBodyUds::bFsmIsServiceAccepted ( void* /*pArg*/ )
{
    dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::bFsmIsServiceAccepted()");
    return (mIsRequestAccepted) ? true : false;
}

//-----------------------------------------------------------------------------

bool
dia_tclDiagSessionBodyUds::bFsmIsServiceInternal ( void* /* pArg */ )
{
   return (mpSession->oDiagMsgBuffer().bIsInternalRequest() == TRUE) ? true : false;
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmValidateRequest ( void* pArg )
{
   dia_tclFnctTrace oTrace("dia_tclDiagSessionBodyUds::vFsmValidateRequest()");

   if ( !pArg ) return;

   mIsRequestAccepted = false;

   dia_EngineServer* pEngine = 0;
   dia_ServiceDispatcher* pDispatcher = 0;
   dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
   if ( pEngineMgr )
   {
      if ( pEngineMgr->queryEngineServer(mpSession->mEngineID,&pEngine) == DIA_SUCCESS )
      {
         pDispatcher = pEngine->getDispatcher();
      }
   }

   if ( !pEngine || !pDispatcher ) {
      DIA_TR_INF("### UNABLE TO GET VALID POINTER TO ENGINE OR DISPATCHER OBJECT ###");
      return;
   }

   dia_Session* pSession = pEngine->getActiveSession();
   std::list<dia_SecurityLevel*> activeSecurityLevels;
   getInstanceOfSecurityManager()->getActiveLevels(activeSecurityLevels);
// dia_SecurityLevel* pSecLevel = getInstanceOfSecurityManager()->pGetLevel();

   // check if the incoming request is supported by the engine
   tDiaResult retCode = pEngine->getServerConfiguration().validateRequest(mpSession->oDiagMsgBuffer(),pSession,activeSecurityLevels);

   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_INF("### ACCESS IS OK ###");
      // access was granted or the decision has to be taken in the service handler
      mIsRequestAccepted = true;
   }
   else
   {
      pDispatcher->setServiceHandler(OSAL_NEW dia_ServiceHandlerWrapper(getInstanceOfNRCGenerator(retCode)));
   }

   dia_tclDiagSession::tclEvent* poEvent = static_cast<dia_tclDiagSession::tclEvent*>(pArg);
   if ( poEvent->getEventID() == ((tS32) dia_tclDiagSession::enEvIdReqRx) )
   {
       OSAL_DELETE poEvent;
   }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmPrepareProcessing ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmPrepareProcessing");

    mpSession->vLookupSrvcHandler();
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmCleanupProcessing ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmCleanupProcessing");

   dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
   if ( pEngineMgr )
   {
      dia_EngineServer* pEngine = 0;
      (void) pEngineMgr->queryEngineServer(mpSession->mEngineID,&pEngine);
      if ( pEngine && pEngine->getDispatcher() )
      {
         (void) pEngine->getDispatcher()->resetServiceHandler();
      }
   }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStartProcessingTimer ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartProcessingTimer");

    // setup the timer object
    mpSession->oTimer.s32SetTime(0,0);

    dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
    if ( pEngineMgr )
    {
       dia_EngineServer* pEngine = 0;
       if ( (pEngineMgr->queryEngineServer(mpSession->mEngineID,&pEngine) == DIA_SUCCESS) && pEngine )
       {
          dia_ServiceDispatcher* pDispatcher = pEngine->getDispatcher();
          if ( pDispatcher )
          {
             dia_ServiceHandler* pServiceHandler = pDispatcher->getServiceHandler();
             if ( pServiceHandler ) mpSession->oTimer.s32SetTime(pServiceHandler->getTimeoutValue(),0);
          }
       }
    }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStopProcessingTimer ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStopProcessingTimer");

    // reset the timer object
    mpSession->oTimer.s32SetTime(0,0);
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStartProcessing ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartProcessing");

    // forward the diagnosis request to the handler
    DIA_TR_INF( "About to call service handler method --- vOnReqRx()");

    dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
    if ( pEngineMgr )
    {
       dia_EngineServer* pEngine = 0;
       if ( pEngineMgr->queryEngineServer(mpSession->mEngineID,&pEngine) == DIA_SUCCESS )
       {
          if ( pEngine && pEngine->getDispatcher() )
          {
             pEngine->getDispatcher()->vProcessRequest();
          }
       }
    }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmProcessingTimeout ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmProcessingTimeout");

    dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
    if ( pEngineMgr )
    {
       dia_EngineServer* pEngine = 0;
       if ( pEngineMgr->queryEngineServer(mpSession->mEngineID,&pEngine) == DIA_SUCCESS )
       {
          if ( pEngine && pEngine->getDispatcher() )
          {
             pEngine->getDispatcher()->getServiceHandler()->vOnTimeout();
          }
       }
    }
}

//-----------------------------------------------------------------------------

//void
//dia_tclDiagSessionBodyUds::vFsmSendResult ( void* /*pArg*/ )
//{
//    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmSendResultnse");
//
//    // Send an intermediate result back
//    mpSession->oDiagMsgBuffer().vSendResonse();
//}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmIgnoreRequest ( void* pArg )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmIgnoreRequest");

    if ( !pArg )
    {
        return;
    }

    dia_tclDiagSession::tclEvent* poEvent = static_cast<dia_tclDiagSession::tclEvent*>(pArg);

    // delete allocated memory for the ignored request
    if ( poEvent->getEventID() == ((tS32) dia_tclDiagSession::enEvIdReqRx) )
    {
        DIA_TR_INF( "--- Received a ReqRx/delete request");

        dia_tclDiagSession::tclEventReqRx* poEventReqRx = reinterpret_cast<dia_tclDiagSession::tclEventReqRx*>(poEvent);
        OSAL_DELETE poEventReqRx->poMsgBuffer();
        OSAL_DELETE poEvent;
    }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmInitRx ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmInitRx");

    mpSession->deleteDiagnosisMessageBuffer();
    // reset the timer
    mpSession->oTimer.s32SetTime(0,0);
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmResetRx( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmResetRx");
}

//-----------------------------------------------------------------------------

//void
//dia_tclDiagSessionBodyUds::vFsmResponseOnResult ( void* pArg )
//{
//    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmResponseOnResult");
//
//    if ( !pArg )
//    {
//        return;
//    }
//}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmSetDiagActive ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmSetDiagActive");

#ifndef VARIANT_S_FTR_DISABLE_DIAG_ACTIVITY

   dia_CmdSetDiagActivity* pCmd = OSAL_NEW dia_CmdSetDiagActivity(TRUE);
   if ( pCmd )
   {
       (void) pCmd->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_1) );
       (void) pCmd->addPredicate( OSAL_NEW dia_PredicateServiceRegistrationCCA(CCA_C_U16_SRV_SPM,CCA_C_U16_APP_SPM) );
       (void) pCmd->addPredicate( OSAL_NEW dia_PredicateServiceStateCCA(CCA_C_U16_SRV_SPM,CCA_C_U16_APP_SPM,TRUE) );

       getInstanceOfCommandController()->addCommand(pCmd);
       DIA_TR_INF("dia_CmdDiagnosisActivity SUCCESSFULLY TRIGGERED.");
   }
   else
   {
      DIA_TR_ERR("dia_CmdDiagnosisActivity TRIGGER FAILED!");
   }
   pCmd = 0;   //lint !e423 Warning: Creation of memory leak in assignment to 'pCmd'. --> lifetime is controlled by command controller

#endif /*VARIANT_S_FTR_DISABLE_DIAG_ACTIVITY*/

}  //lint !e438 Warning: last value assigned to variable not used

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmSetDiagInactive ( void* /* pArg */ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmSetDiagInactive");

#ifndef VARIANT_S_FTR_DISABLE_DIAG_ACTIVITY

   dia_CmdSetDiagActivity* pCmd = OSAL_NEW dia_CmdSetDiagActivity(FALSE);
   if ( pCmd )
   {
      (void) pCmd->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_1) );
      (void) pCmd->addPredicate( OSAL_NEW dia_PredicateServiceRegistrationCCA(CCA_C_U16_SRV_SPM,CCA_C_U16_APP_SPM) );
      (void) pCmd->addPredicate( OSAL_NEW dia_PredicateServiceStateCCA(CCA_C_U16_SRV_SPM,CCA_C_U16_APP_SPM,TRUE) );

      getInstanceOfCommandController()->addCommand(pCmd);
      DIA_TR_INF("dia_CmdDiagnosisActivity SUCCESSFULLY TRIGGERED.");
   }
   else
   {
      DIA_TR_ERR("dia_CmdDiagnosisActivity TRIGGER FAILED!");
   }
   pCmd = 0;   //lint !e423 Warning: Creation of memory leak in assignment to 'pCmd'. --> lifetime is controlled by command controller

#endif /*VARIANT_S_FTR_DISABLE_DIAG_ACTIVITY*/

}  //lint !e438 Warning: last value assigned to variable not used

//-----------------------------------------------------------------------------

//void
//dia_tclDiagSessionBodyUds::vFsmReemitEvent ( void* pArg )
//{
//   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmReemitEvent");
//
//   if ( !pArg )
//   {
//       return;
//   }
//
//   dia_tclDiagSession::tclEvent* poEvent = static_cast<dia_tclDiagSession::tclEvent*>(pArg);
//
//   // delete allocated memory for the ignored request
//   if ( poEvent->getEventID() == ((tS32) dia_tclDiagSession::enEvIdReqRx) )
//   {
//       DIA_TR_INF( "--- Reemit ReqRx request");
//
//       dia_tclDiagSession::tclEventReqRx* poEventReqRx = reinterpret_cast<dia_tclDiagSession::tclEventReqRx*>(poEvent);
//       mpSession->vEmit(OSAL_NEW dia_tclDiagSession::tclEventReqRx(poEventReqRx->poMsgBuffer()));
//   }
//}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStartTests ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartTests");

#if defined(VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG) || defined(VARIANT_S_FTR_ENABLE_TESTS_ON_DIAG_ACTIVITY)
    dia_TestController* pTestCtrl = getInstanceOfTestController();
    if ( pTestCtrl )
    {
        DIA_TR_INF( "--- runTests(DIA_EN_TESTCONDITION_DIAGNOSIS_ACTIVATED)");
        (void) pTestCtrl->runTests(DIA_EN_TESTCONDITION_DIAGNOSIS_ACTIVATED);
    }
#endif
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmAdoptRequest ( void* pArg )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmAdoptRequest");

    if ( !pArg )
    {
        return;
    }

    dia_tclDiagSession::tclEvent* poEvent = static_cast<dia_tclDiagSession::tclEvent*>(pArg);

    // delete allocated memory for the ignored request
    if ( poEvent->getEventID() == ((tS32) dia_tclDiagSession::enEvIdReqRx) )
    {
        DIA_TR_INF( "--- Adopting ReqRx request");

        dia_tclDiagSession::tclEventReqRx* poEventReqRx = reinterpret_cast<dia_tclDiagSession::tclEventReqRx*>(poEvent);
        tDiaResult resultCode = mpSession->setDiagnosisMessageBuffer(*poEventReqRx);
        if ( resultCode != DIA_SUCCESS )
        {
           DIA_TR_ERR("##### FAILED TO ADOPT MESSAGE BUFFER OF RECEIVED DIAGNOSIS REQUEST (ERR=0x%08x) #####",resultCode);
        }
    }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStartConfirmationTimer ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartConfirmationTimer");

    // setup the timer object
    mpSession->oTimer.s32SetTime(0,0);
    mpSession->oTimer.s32SetTime(MAX_TIME_WAIT_CONF_AND_QUIT, 0);
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStopConfirmationTimer ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStopConfirmationTimer");

//    mpSession->oTimer.s32SetTime(0,0);
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmSendConfirmation ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmSendConfirmation");

    // send the confirmation
    mpSession->oDiagMsgBuffer().vSendResponse();
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmConfirmationTimeout ( void* /*pArg*/ )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmConfirmationTimeout");

    DIA_TR_INF("Received event enEvIdTimeout --- Missing EventConfTxOk");

    // Send an event to self so as to come back to ReadyForReqRx state.
    mpSession->vEmit(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk());
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vAcceptEvent ( const dia_tclDiagSession::tclEvent& oEvent )
{
    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vAcceptEvent()");

    FsmEvent eventMap[dia_tclDiagSession::enNumberOfEvents] = {
        evUnknown,
        evTimeout,
        evReqRx,
        evResReadyAndQuit,
        evConfTxOk,
        evIdle,
        evIntMsgRx
    };

    DIA_TR_INF( "Accept tclEvent Id=%d, size=%zu", oEvent.getEventID(), sizeof(oEvent));

    if ( mpFSM )
    {
        DIA_TR_INF( "### State Before: %s", mpFSM->getStateName());
        mpFSM->acceptEvent(eventMap[oEvent.getEventID()],(void*) const_cast<dia_tclDiagSession::tclEvent*>(&oEvent));
        DIA_TR_INF( "### State After : %s", mpFSM->getStateName());
    }
    else
    {
        DIA_TR_INF( "### Event Not Accepted. No FSM !!!");
    }
}

//void
//dia_tclDiagSessionBodyUds::vFsmStartActivityTimer ( void* /*pArg*/ )
//{
//    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartActivityTimer");
//
//    // setup the timer object
//    mpSession->oTimer.s32SetTime(MAX_TIME_DIAG_ACTIVITY, 0);
//}

//-----------------------------------------------------------------------------

//void
//dia_tclDiagSessionBodyUds::vFsmStopActivityTimer ( void* /*pArg*/ )
//{
//    dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStopActivityTimer");
//
//    mpSession->oTimer.s32SetTime(0,0);
//}

void
dia_tclDiagSessionBodyUds::vFsmDispatchInternalMsg ( void* pArg )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmDispatchInternalMsg");

   if ( !pArg ) return;

   dia_tclDiagSession::tclEvent* poEvent = static_cast<dia_tclDiagSession::tclEvent*>(pArg);

   if ( poEvent->getEventID() == ((tS32) dia_tclDiagSession::enEvIdIntMsgRx) )
   {
#ifndef __DIA_UNIT_TESTING__
      dia_tclDiagSession::tclEventIntMsgRx* poEventIntMsgRx = static_cast<dia_tclDiagSession::tclEventIntMsgRx*>(poEvent);
//      if ( poEventIntMsgRx )
//      {
         (void) poEventIntMsgRx->execute();
//      }
         OSAL_DELETE poEvent;
#else
      DIA_TR_ERR("### dia_tclDiagSessionBodyUds::vFsmDispatchInternalMsg NOT IMPLEMENTED FOR UT");
#endif
   }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmPostProcessingTimeout ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmPostProcessingTimeout");
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStartPostProcessing ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartPostProcessing");
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStartPostProcessingTimer ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStartPostProcessingTimer");
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSessionBodyUds::vFsmStopPostProcessingTimer ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_tclDiagSessionBodyUds::vFsmStopPostProcessingTimer");
}

