/*****************************************************************************************
 *
 * \file    dia_ISystemCCA.h
 *
 * \brief   Definition of the interface for CCA system framework functionality
 *
 * \author  AI/PJ-VW36 - gib2hi
 * \date    2008-09-09
 *
 * (c) 2008 Robert Bosch GmbH, Blaupunkt GmbH
 *
 ****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_CCA__
#define __INCLUDED_DIA_INTERFACE_SYSTEM_CCA__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

class amt_tclBaseMessage;

class dia_ISystemCCA
{
   DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_SYSTEM_FRAMEWORK_CCA)

public:
    //! called from framework to log registration details
    virtual tDiaResult onRegistrationID ( tU16 u16RegID, tU16 u16AppID, tU16 u16SrvID, tU16 u16SrcSubID ) = 0;

    //! overwritten method of ahl_tclBaseWork, called from diagnostics_tclApp::vOnServiceState()
    virtual tDiaResult onServiceState ( tU16 u16SrvID, tU16 u16AppID, tU16 u16RegID, tU8 u8SrvState, tU16 u16SubId) = 0;

    //! Dispatcher for messages - call this function if there's a new message to dispatch
    virtual tDiaResult onDispatchMessage(amt_tclBaseMessage *pBaseMessage) = 0;

    virtual size_t getNumberOfSystemAdapters ( void ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_ISystemCCA ( void ) {}
};

#endif
