/**
 * \file dia_IDiaglibDiagnosisDataListener.h
 * \author eva2hi
 * \date 24.11.2008
 * \brief Interface of a plugin that can be plugged into a SystemAdapter
 *
 * Interface of a plugin that can be plugged into SystemAdapters
 * to extend the set of messages that is supported by them.
 */
#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__

#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#include <framework/SystemAdapter/dia_DataTypes.h>
#endif

class dia_IDiaglibDiagnosisDataListener
{
public:
   /***********************************************************************//**
   * \brief Called on the result of a system set.
   *
   * \param[in]  enRoutineStatus The result of this routine control action
   * \param[in]  oStartResult    in case of error: the cause
   *                             when ok and short running routine the result
   *
   * \return         n/a
   *//*************************************************************************/
   virtual tVoid vOnDiagnosisDataResult (
                                         tU32 u32DiagnosisDataId,
                                         tenDiagDataResult enDiagnosisDataStatus, 
                                         const tDiaglibParamVector& oStartResult
                                      ) = 0;

   virtual ~dia_IDiaglibDiagnosisDataListener() {}
};

#endif /* __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__ */
