/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Service Handler CCA - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

// MIDW_FI DEFINES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS

// FI DEFINES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_DIAGLIB_CCA_HELPER__
#include "../../depricated/SystemAdapter/dia_DiaglibCcaHelper.h"
#endif

#define DIA_FILE_CURRENT   DIA_FILE_U16_SA_DIAGLIB_CCA_HELPER

/***********************************************************************//**
 * \brief Fills a midw_fi value list from a diaglib internal vector
 *
 * Transforms the ParameterVector which is the diaglib internal type for
 * variable value lists into the midw_fi type representing a ValueList.
 *
 * \param[in] oVector Source vector
 * \param[out] oValueList Target value list
 *
 * \return none
 *//************************************************************************/
tVoid dia_DiaglibCcaHelper::vFillCcaValueListFromVector(const tDiaglibParamVector& oVector, midw_fi_tcl_ValueList& oValueList)
{
   dia_tclFnctTrace oTrace("dia_DiaglibCcaHelper::vFillCcaValueListFromVector");
   const tU32 u32Size = static_cast<tU32>( oVector.size() );

   if( static_cast<tU32>(oValueList.ValueList.size()) != 0 )
   {
      return;
   }

   for ( tU32 i = 0; i < u32Size; ++i )
   {
      midw_fi_tcl_ValueUnion oValueUnion;

      vConvertDiaglibUnionToCcaUnion(oVector[i], oValueUnion);

      oValueList.ValueList.push_back(oValueUnion);
   }


}

/***********************************************************************//**
 * \brief Fills a midw_fi value list from a diaglib internal vector
 *
 * Transforms the ParameterVector which is the diaglib internal type for
 * variable value lists into the midw_fi type representing a ValueList.
 *
 * \param[in] oVector Source vector
 * \param[out] oValueList Target value list
 *
 * \return none
 *//************************************************************************/
tVoid dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(const midw_fi_tcl_ValueList& oValueList, tDiaglibParamVector& oVector)
{
   dia_tclFnctTrace oTrace("dia_DiaglibCcaHelper::vFillVectorFromCcaValueList");
   const tU32 u32Size = static_cast<tU32>(oValueList.ValueList.size());
   trParameter rParameter;

   if( static_cast<tU32>(oVector.size()) != 0 )
   {
      return;
   }

   for ( tU32 i = 0; i < u32Size; ++i )
   {
      vConvertCcaUnionToDiaglibUnion(oValueList.ValueList[i], rParameter);

      oVector.push_back(rParameter);
   }


}

/***********************************************************************//**
 * \brief Converts a midw_fi union to a diaglib internal union
 *
 * See brief. This is a helper function to the function that converts whole
 * ValueLists (containing midw_fi unions) to Vectors (containing int. unions)
 *
 * \param[in] oCcaIn Source CCA union in
 * \param[out] oDiagLibOut Target diaglib union out
 *
 * \return none
 *//************************************************************************/
tVoid dia_DiaglibCcaHelper::vConvertCcaUnionToDiaglibUnion( const midw_fi_tcl_ValueUnion& oCcaIn, trParameter& oDiagLibOut )
{
   dia_tclFnctTrace oTrace("dia_DiaglibCcaHelper::vConvertCcaUnionToDiaglibUnion");
   tU8 u8Type = (tU8) oCcaIn.ValueUnionType.enType;
   oDiagLibOut.enType = static_cast<tenParameterType>(u8Type); //lint !e1744: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed

   switch(oDiagLibOut.enType)
   {
      case EN_PARAMETER_TYPE_BOOL:
      {
       oDiagLibOut.bValue = (static_cast<midw_fi_tclBool*>(oCcaIn.poValueUnionData))->bValue; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_U8:
      {
         oDiagLibOut.u8Value = (static_cast<midw_fi_tclU8*>(oCcaIn.poValueUnionData))->u8Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_U16:
      {
         oDiagLibOut.u16Value = (static_cast<midw_fi_tclU16*>(oCcaIn.poValueUnionData))->u16Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_U32:
      {
         oDiagLibOut.u32Value = (static_cast<midw_fi_tclU32*>(oCcaIn.poValueUnionData))->u32Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_S8:
      {
         oDiagLibOut.s8Value = (static_cast<midw_fi_tclS8*>(oCcaIn.poValueUnionData))->s8Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_S16:
      {
         oDiagLibOut.s16Value = (static_cast<midw_fi_tclS16*>(oCcaIn.poValueUnionData))->s16Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_S32:
      {
         oDiagLibOut.s32Value = (static_cast<midw_fi_tclS32*>(oCcaIn.poValueUnionData))->s32Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_F32:
      {
         oDiagLibOut.f32Value = (static_cast<midw_fi_tclF32*>(oCcaIn.poValueUnionData))->f32Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_F64:
      {
         oDiagLibOut.f64Value = (static_cast<midw_fi_tclF64*>(oCcaIn.poValueUnionData))->f64Value; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         break;
      }
      case EN_PARAMETER_TYPE_U8ERROR:
      {
         midw_fi_tcl_e8_InternalError::tenType enType;
         tU8 u8ErrorType;

         enType = static_cast<midw_fi_tcl_e8_InternalError*>(oCcaIn.poValueUnionData)->enType; //lint !e1774: Could use dynamic_cast to downcast polymorphic type, but dynamic_cast is not allowed
         u8ErrorType = static_cast<tU8>(enType);

         oDiagLibOut.u8ErrorValue = static_cast<tenInternalError>(u8ErrorType);
         break;
      }
      default:
      {
         break;
      }
   } //lint !e788: intentionally not all items used within defaulted switch

}

/***********************************************************************//**
 * \brief Converts a diaglib internal union to a midw_fi union
 *
 * See brief. This is a helper function to the function which converts whole
 * Vectors (containing int. unions) to ValueLists (containing midw_fi unions)
 *
 * \param[in] oDiagLibIn Source diaglib union in
 * \param[out] oCcaOut Target CCA union out
 *
 * \return none
 *//************************************************************************/
tVoid dia_DiaglibCcaHelper::vConvertDiaglibUnionToCcaUnion( const trParameter& oDiagLibIn, midw_fi_tcl_ValueUnion& oCcaOut )
{
   dia_tclFnctTrace oTrace("dia_DiaglibCcaHelper::vConvertDiaglibUnionToCcaUnion");
   tU8 u8Type = static_cast<tU8>(oDiagLibIn.enType);
   oCcaOut.ValueUnionType.enType = static_cast<midw_fi_tcl_e8_ValueType::tenType>(u8Type);

   switch(oDiagLibIn.enType)
   {
      case EN_PARAMETER_TYPE_BOOL:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclBool, bValue, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U8:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU8, u8Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U16:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU16, u16Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U32:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU32, u32Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_S8:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclS8, s8Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_S16:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclS16, s16Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_S32:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclS32, s32Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_F32:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclF32, f32Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_F64:
      {
         DIA_CONVERT_DIAGLIB_TO_CCA(midw_fi_tclF64, f64Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U8ERROR:
      {
         tU32 u32MediatorValue;
         midw_fi_tcl_e8_InternalError* oVal = OSAL_NEW midw_fi_tcl_e8_InternalError();
         if(OSAL_NULL == oVal)
         {
            DIA_FATAL_ASSERT_ALWAYS();
            break; // Not reachable, but lint doesn't now that
         }

         u32MediatorValue = static_cast<tU32>(oDiagLibIn.u8ErrorValue);
         oVal->enType = static_cast<midw_fi_tcl_e8_InternalError::tenType>(u32MediatorValue);

         oCcaOut.poValueUnionData = oVal;
         break;
      }
      default:
      {
         break;
      }
   } //lint !e788: intentionally not all items used within defaulted switch

}

