#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#define __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h" //lint !e451 Warning: Header file repeatedly included but does not have a standard include guard
#endif



//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#ifndef __INCLUDED_DIA_STL__
//#include "../../common/framework/application/dia_stl.h"
//#endif

//lint -e451 Warning: Header file repeatedly included but does not have a standard include guard
//lint -e537 Warning: Repeated include file


//lint +e451 Warning: Header file repeatedly included but does not have a standard include guard
//lint +e537 Warning: Repeated include file




enum tenInternalError
{
   EN_ERROR_ID_NOT_SUPPORTED = 0,
   EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE = 1,
   EN_ERROR_ROUTINE_NOT_RUNNING = 2,
   EN_ERROR_WRITE_NOT_SUPPORTED = 3,
   EN_ERROR_READ_NOT_SUPPORTED = 4,
   EN_ERROR_ROUTINE_NEVER_RAN = 5,
   EN_ERROR_ROUTINE_STILL_RUNNING = 6,
   EN_ERROR_DEFSET_IN_PROGRESS = 7,
   EN_ERROR_FATAL_INTERNAL = 8,
   EN_ERROR_IOCONTROL_NOT_SUPPORTED          = 9,
   EN_ERROR_IOCONTROL_ACTIONID_NOT_SUPPORTED = 10,
   EN_ERROR_NO_DATA                          = 11,
   EN_ERROR_DATA_LENGTH_INCORRECT            = 12,
   EN_ERROR_NOT_DEFINED                      = 13,
//   EN_ERROR_DATA_NOT_TRANSIMTTED             = 14,
   EN_ERROR_NO_ERROR = 9999
};

/**
 * Result of a diagnosis data operation
 * \ingroup        diaglibAPI
 */
enum tenDiagDataResult
{
   EN_DIAGDATA_OK = 0,
   EN_DIAGDATA_NOT_OK = 1
};

/**
 * IO control action identifier
 * \ingroup        diaglibAPI
 */
enum tenIoControlAction
{
   EN_ACTION_FREEZE = 0,
   EN_ACTION_UNFREEZE = 1,
   EN_ACTION_SET = 2,
   EN_ACTION_SET_TO_DEFAULT = 3
};

/**
 * Result of a IO control operation
 * \ingroup        diaglibAPI
 */
enum tenIoCtrlResult
{
   EN_IO_CONTROL_OK = 0,
   EN_IO_CONTROL_NOT_OK = 1
};

/**
 * Bit identifiers of routine bit mask
 * \ingroup        diaglibAPI
 */
enum tenRoutineBitMask
{
   EN_ROUTINE_FLAG_WRITE_TO_RM = 0,
   EN_ROUTINE_FLAG_SUPRESS_RESULT = 1
};

/**
 * Result of a routine control operation
 * \ingroup        diaglibAPI
 */
enum tenRoutineCtrlResult
{
   EN_ROUTINE_CONTROL_OK = 0,
   EN_ROUTINE_CONTROL_NOT_OK = 1,
   EN_ROUTINE_CONTROL_STARTED = 2
};

#define DIAGLIB_SYSTEM_SET_TYPE_MIN 0
#define DIAGLIB_SYSTEM_SET_TYPE_MAX 9
/**
 * Type of system set identifier
 * \ingroup        diaglibAPI
 */
enum tenSystemSetType
{
   EN_TYPE_DEFAULT_HMI      =  0,
   EN_TYPE_DEFAULT_TEF      =  1,
   EN_TYPE_CODING           =  2,
   EN_TYPE_CALIBRATION      =  3,
   EN_TYPE_DEFAULT_CUSTOMER =  4,
   EN_TYPE_UM_RESET_ALL     =  5, // User Management reset all users
   EN_TYPE_UM_RESET_USER    =  6, // User Management reset single users
   EN_TYPE_UM_RESET_BANK    =  7, // User Management reset single bank
   EN_TYPE_UM_SWITCH_USER   =  8, // User Management switch user
   EN_TYPE_UM_SWITCH_BANK   =  9, // User Management switch bank
   EN_TYPE_UM_SAVE_BANK     = 10  // User Management save bank
};

/**
 * Result of a system set operation
 * \ingroup        diaglibAPI
 */
enum tenSystemSetResult
{
   EN_SYSTEMSET_OK = 0,
   EN_SYSTEMSET_NOT_OK = 1
};

enum tenParameterType
{
   EN_PARAMETER_TYPE_BOOL        = 0,
   EN_PARAMETER_TYPE_U8          = 1,
   EN_PARAMETER_TYPE_U16         = 2,
   EN_PARAMETER_TYPE_U32         = 3,
   EN_PARAMETER_TYPE_S8          = 4,
   EN_PARAMETER_TYPE_S16         = 5,
   EN_PARAMETER_TYPE_S32         = 6,
   EN_PARAMETER_TYPE_F32         = 7,
   EN_PARAMETER_TYPE_F64         = 8,
   EN_PARAMETER_TYPE_U8ERROR     = 9,
   EN_PARAMETER_TYPE_ARRAY_U8    = 10
};

/**
 * Parameter union with additional member that stores the type of the parameter
 * A vector of this datatype describes a ParameterList, ResultList or ErrorList
 * in the FI description.
 * \ingroup        diaglibAPI
 */
struct trParameter
{
   union
   {
      tBool bValue;
      tF32 f32Value;
      tF64 f64Value;
      tS16 s16Value;
      tS32 s32Value;
      tS8 s8Value;
      tU16 u16Value;
      tU32 u32Value;
      tenInternalError u8ErrorValue;
      tU8 u8Value;
   };
   /**
    * type of parameter
    */
   tenParameterType enType;

   trParameter() {enType = EN_PARAMETER_TYPE_U32; u32Value=0x00;}
};

typedef std::vector<trParameter> tDiaglibParamVector;

#endif
