/**
 * @file WBLASFServiceComponent.cpp
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 *
 * @{
 */

#include "GenericNetlink.h"
#include "Poller.h"
#include "WBLServiceFactory.h"
#include "WBLASFServiceComponent.h"
#include "LoopbackService.h"

namespace org {
	namespace bosch {

using namespace ::asf::core;

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/asf", WBLASFServiceComponent, Info);

WBLASFServiceComponent::WBLASFServiceComponent() :
      BaseComponent()
{
   LOG_INFO ("%s", __func__);
   cPoller::getInstance()->iRegisterForPoll(cGenNetLink::getInstance());
   _loopbackservice = new cLoopbackService();
}

WBLASFServiceComponent::~WBLASFServiceComponent()
{
   try
   {
      LOG_INFO ("%s", __func__);
      cPoller::getInstance()->iUnRegisterFromPoll(cGenNetLink::getInstance());
      cGenNetLink::deleteInstance();
      cPoller::deleteInstance();
      delete _loopbackservice;
   }catch(...){}
}

	}
}

/** @} */
