/**
 * @file WifiSetupManager.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_WIFI_SETUP_MANAGER_H
#define _I_WIFI_SETUP_MANAGER_H

#include "asf/core/Logger.h"

#include "WBLTypes.h"
#include "WBLPortsDefines.h"
#include "IWBLServiceProperties.h"
#include "IWBLServiceResponse.h"
#include "WifiSetupService.h"
#include "WBLServiceFactory.h"

namespace org
{
namespace bosch
{

using namespace ::asf::core;

typedef ::std::map<::std::string, ::asf::dbus::DBusVariant> PropertiesList;

class WifiSetupManager final: public IWBLServiceProperties,
                        public IWBLServiceResponse
{
   public:
      WifiSetupManager();
      WifiSetupManager(const WifiSetupManager &r) = delete;
      const WifiSetupManager &operator=(const WifiSetupManager &r) = delete;
      virtual ~WifiSetupManager();

      virtual void onWBLServiceResponse(const ::boost::shared_ptr< WBLBaseMsg > msg) override;

      //! Interfaces of ConflictManagementServiceIf
      virtual void onActiveWifiSetupsChanged(const ActiveWifiSetupsMsg& msg) override;
      virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& propertiesMap) override;
      virtual void getDBusObjectPath(::std::string& objPath) override;
      virtual void getInterfaceName(::std::string& interfaceName) override;

      WifiSetupService* getAPWifiSetup();
      WifiSetupService* getSTAWifiSetup();

      void updateInterfaceAdded(WifiSetUpItem& item);
      void updateInterfaceRemoved(WifiSetUpItem& item);

      bool isAPSetupAvaialable();
      bool isSTASetupAvaialable();

   private:

      bool isSetupExist(const WifiSetUpItem& item,const WifiSetUpList list);
      bool isSetupPropertiesChanged(const WifiSetUpItem& item);
      bool isSetupRemoved(const WifiSetUpList list);
      void updateWifiSetup(WifiSetUpItem& item);

      WifiSetUpList _wifiSetupList;
      WifiSetupService* _poAPSetUp;
      WifiSetupService* _poSTASetUp;

      DECLARE_CLASS_LOGGER();
};

}//namespace bosch
}//namespace org

#endif //_I_CONFLICT_MANAGEMENT_SERVICE_H

/** @} */
