/**
 * @file ObjectManagerService.cpp
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "ObjectManagerService.h"

namespace org
{
namespace bosch
{

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/WBLServices", ObjectManagerService, Debug);

ObjectManagerService::ObjectManagerService(::std::string portName) :
      ObjectManagerStub(portName)
{
   LOG_INFO("ObjectManagerService:Constructor");
   _interfaceEmitted = false;
}//void ObjectManagerService::ObjectManagerService

ObjectManagerService::~ObjectManagerService()
{

}//void ObjectManagerService::~ObjectManagerService

void ObjectManagerService::onActiveWifiSetupsChanged(const ActiveWifiSetupsMsg& msg)
{
   (void)msg;
   if(isInterfaceUpdated())
   {
      WBLServiceFactory::getInstance()->getConflictManagementServiceIf()->updateInterfaceAdded();
      WBLServiceFactory::getInstance()->getLastIntendedModeServiceIf()->updateInterfaceAdded();
      setInterfaceEmitted(true);
   }
}

void ObjectManagerService::onGetManagedObjectsRequest(const ::boost::shared_ptr<GetManagedObjectsRequest>& request)
{
   LOG_INFO("ObjectManagerService:onGetManagedObjectsRequest");
   WBL_INTENTIONALLY_UNUSED(request);

   WBLServicesList serviceList;
   WifiSetupService* wifiSetup;

   bindConflictManagementInterface(serviceList);
   WBLServiceFactory* serviceFactory = WBLServiceFactory::getInstance();
   WifiSetupManager* wifiSetupManager = serviceFactory->getWifiSetupManager();
   if (wifiSetupManager->isAPSetupAvaialable())
   {
      wifiSetup = wifiSetupManager->getAPWifiSetup();
      bindWifiSetupInterface(serviceList, wifiSetup);
   }
   if (wifiSetupManager->isSTASetupAvaialable())
   {
      wifiSetup = wifiSetupManager->getSTAWifiSetup();
      bindWifiSetupInterface(serviceList, wifiSetup);
   }
   bindLastIntendedModeInterface(serviceList);

   sendGetManagedObjectsResponse(serviceList);
}//void ObjectManagerService::onGetManagedObjectsRequest

void ObjectManagerService::bindConflictManagementInterface(WBLServicesList &serviceList)
{
   LOG_INFO("ObjectManagerService:bindConflictManagementInterface");

   InterfaceList interfacList;
   PropertiesList propertiesList;
   ::std::string objPath, interfacename;

   WBLServiceFactory* serviceFactory = WBLServiceFactory::getInstance();
   ConflictManagementService* conflictMgrServiceIf =
         (serviceFactory) ? (serviceFactory->getConflictManagementServiceIf()) : (nullptr);
   if (conflictMgrServiceIf)
   {
      conflictMgrServiceIf->getAllProperties(propertiesList);
      conflictMgrServiceIf->getDBusObjectPath(objPath);
      conflictMgrServiceIf->getInterfaceName(interfacename);
   }
   interfacList.insert(std::make_pair(interfacename, propertiesList));
   serviceList.insert(std::make_pair(objPath, interfacList));
}//void ObjectManagerService::bindConflictManagementInterface

void ObjectManagerService::bindWifiSetupInterface(WBLServicesList &serviceList, WifiSetupService *wifiSetup)
{
   LOG_INFO("ObjectManagerService:bindWifiSetupInterface");

   InterfaceList interfacList;
   PropertiesList propertiesList;
   ::std::string objPath, interfacename;
   wifiSetup->getAllProperties(propertiesList);
   wifiSetup->getDBusObjectPath(objPath);
   wifiSetup->getInterfaceName(interfacename);
   interfacList.insert(std::make_pair(interfacename, propertiesList));
   serviceList.insert(std::make_pair(objPath, interfacList));
}//void ObjectManagerService::bindWifiSetupInterface

void ObjectManagerService::bindLastIntendedModeInterface(WBLServicesList &serviceList)
{
   LOG_INFO("ObjectManagerService:bindLastIntendedModeInterface");
   InterfaceList interfacList;
   PropertiesList propertiesList;
   ::std::string objPath, interfacename;
   WBLServiceFactory* serviceFactory = WBLServiceFactory::getInstance();
   LastIntendedModeService* lastIntendedServiceIf =
         (serviceFactory) ? (serviceFactory->getLastIntendedModeServiceIf()) : (nullptr);
   if (lastIntendedServiceIf)
   {
      lastIntendedServiceIf->getAllProperties(propertiesList);
      lastIntendedServiceIf->getDBusObjectPath(objPath);
      lastIntendedServiceIf->getInterfaceName(interfacename);
   }
   interfacList.insert(std::make_pair(interfacename, propertiesList));
   serviceList.insert(std::make_pair(objPath, interfacList));
}//void ObjectManagerService::bindLastIntendedModeInterface

void ObjectManagerService::updateInterfaceAddedSignal(const ::std::string& objectPath,
      const ::std::string& interfacename, const PropertiesList& propertiesList)
{
   LOG_INFO("ObjectManagerService:updateInterfaceAddedSignal");
   InterfaceList interfacList;
   interfacList.insert(std::make_pair(interfacename, propertiesList));
   sendInterfacesAddedSignal(objectPath,interfacList);
}//void ObjectManagerService::updateInterfaceAddedSignal

void ObjectManagerService::updateInterfaceRemovedSignal(const ::std::string& objectPath,
      const ::std::vector< ::std::string>& interfaces)
{
   LOG_INFO("ObjectManagerService:updateInterfaceRemovedSignal");
   sendInterfacesRemovedSignal(objectPath,interfaces);
}//void ObjectManagerService::updateInterfaceRemovedSignal

bool ObjectManagerService::isInterfaceUpdated()
{
   return _interfaceEmitted;
}//void ObjectManagerService::isInterfaceUpdated

void ObjectManagerService::setInterfaceEmitted(bool val)
{
   _interfaceEmitted = val;
}//void ObjectManagerService::setInterfaceEmitted

} //namespace bosch
} //namespace org

/** @} */
