/**
 * @file ObjectManagerService.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _OBJECT_MANAGER_SERVICE_H
#define _OBJECT_MANAGER_SERVICE_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"

#include "WBLASFComponent.h"
#include "LastIntendedModeService.h"
#include "ConflictManagementService.h"
#include "WifiSetupService.h"
#include "WifiSetupManager.h"
#include "WBLServiceFactory.h"

#include "objmgr/org/freedesktop/DBus/ObjectManagerStub.h"

namespace org
{
namespace bosch
{

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;
using namespace ::asf::core;

typedef ::std::map<::std::string, ::std::map<::std::string, ::std::map<::std::string, ::asf::dbus::DBusVariant> > > WBLServicesList;
typedef ::std::map<::std::string, ::std::map<::std::string, ::asf::dbus::DBusVariant> > InterfaceList;
typedef ::std::map<::std::string, ::asf::dbus::DBusVariant> PropertiesList;

class ObjectManagerService final: public ObjectManagerStub
{

public:
   ObjectManagerService(::std::string portName);
   virtual ~ObjectManagerService();

   //! Interfaces of ObjectManagerStub
   virtual void onGetManagedObjectsRequest(const ::boost::shared_ptr<GetManagedObjectsRequest>& request) override;

   void onActiveWifiSetupsChanged(const ActiveWifiSetupsMsg& msg);

   //! Signals from ObjectManagerStub

   void updateInterfaceAddedSignal(const ::std::string& objectPath, const ::std::string& interfacename,
         const PropertiesList& propertiesList);
   void updateInterfaceRemovedSignal(const ::std::string& objectPath,const ::std::vector< ::std::string>& interfaces);

   bool isInterfaceUpdated();
   void setInterfaceEmitted(bool val);

private:
   void bindConflictManagementInterface(WBLServicesList &serviceList);
   void bindWifiSetupInterface(WBLServicesList &serviceList, WifiSetupService *wifiSetup);
   void bindLastIntendedModeInterface(WBLServicesList &serviceList);DECLARE_CLASS_LOGGER();
   bool _interfaceEmitted;

};

} //namespace bosch
} //namespace org

#endif //_OBJECT_MANAGER_SERVICE_H
/** @} */
