/**
 * @file LastIntendedModeService.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 *
 * @brief 
 *
 * @{
 */

#ifndef _LAST_INTENDED_MODE_SERVICE_H
#define _LAST_INTENDED_MODE_SERVICE_H

#include "org/bosch/wbl/LastIntendedModeStub.h"
#include "ILastIntendedModeService.h"

namespace org
{
namespace bosch
{

typedef ::std::map<::std::string, ::asf::dbus::DBusVariant> svMap;
using namespace ::org::bosch::wbl::LastIntendedMode;
using namespace ::asf::core;

class LastIntendedModeService final: public LastIntendedModeStub, public ILastIntendedModeService
{

public:
   LastIntendedModeService(::std::string sPortName);
   virtual ~LastIntendedModeService();

   virtual void onSetupAdded(const WifiSetUpItem& setupItem) override;
   virtual void onSetupRemoved(const ::std::string& objPath) override;
   virtual void onSetupUpdated(const WifiSetUpItem& setupItem) override;

   //! Function to support ObjectManagerService
   virtual void getAllProperties(::std::map<::std::string, ::asf::dbus::DBusVariant>& propertiesMap);
   virtual void getDBusObjectPath(::std::string& objPath);
   virtual void getInterfaceName(::std::string& interfaceName);

   virtual void updateAPConfigurations(const APConfig &apConfig);

   void updateInterfaceAdded();
   void updateInterfaceRemoved();

private:

   void readLIMOnStartup();
   void populateLIMItems(const LIMList& limList);
   void populateLIMMap(svMap& limMap, const LIMItem& item);
   void populateLIMUpdate(const LIMList& limList);
   void checkPoweredSetting(LIMItem item,const bool isPowered);

   void addLIMItem(const WifiSetUpItem& item);
   void addLIMItem(const LIMItem& item);

   void removeLIMItem(const ::std::string& objPath);
   void printLIMItem(const LIMItem& item);

   void addLIMItemToDB(const LIMItem& item);
   void removeLIMItemFromDB(const ::std::string& objPath);

   bool getLIMItems(LIMList& limList)const;
   
   bool getAPSetupItem(WifiSetUpItem &item);

   void restoreOnRestrictedAP();

   /** Map with key = Setup Object Path and value = LIMItem **/
   std::map<::std::string, LIMItem> _limItems;

   DECLARE_CLASS_LOGGER();
};

} //namespace bosch
} //namespace org

#endif //_LAST_INTENDED_MODE_SERVICE_H

/** @} */
