/**
 * @file ConflictManagementPrepareSetup.cpp
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "WBLDefines.h"
#include "ConflictManagementPrepareSetup.h"

namespace org 
{
namespace bosch 
{

ConflictManagementPrepareSetup::ConflictManagementPrepareSetup() : DbusProperties("PrepareSetup"),
   _propertyMode("Mode"),
   _propertyAPConfig("APConfig"),
   _propertyType("Type"),
   _propertySSID("SSID"),
   _propertySSIDValue("ssid"),
   _propertySSIDutf8("utf8"),
   _propertyPassphrase("Passphrase"),
   _propertySecurity("Security"),
   _propertyVisibility("Visibility"),
   _propertyFrequency("Frequency"),
   _propertyChannel("Channel"),
   _propertyStationsToBeReserved("StationsToBeReserved"),
   _propertySeperateAP("SeperateAP"),
   _propertyP2PConfig("P2PConfig"),
   _propertyGOIntent("GoIntent")
{
   _string2EnumList[_propertyMode] = (int)PREPARESETUP_MODE;
   _string2EnumList[_propertyAPConfig] = (int)PREPARESETUP_APCONFIG;
   _string2EnumList[_propertyType] = (int)PREPARESETUP_TYPE;
   _string2EnumList[_propertySSID] = (int)PREPARESETUP_SSID;
   _string2EnumList[_propertySSIDValue] = (int)PREPARESETUP_SSID_VALUE;
   _string2EnumList[_propertySSIDutf8] = (int)PREPARESETUP_SSID_UTF8;
   _string2EnumList[_propertyPassphrase] = (int)PREPARESETUP_PASSPHRASE;
   _string2EnumList[_propertySecurity] = (int)PREPARESETUP_SECURITY;
   _string2EnumList[_propertyVisibility] = (int)PREPARESETUP_VISIBILITY;
   _string2EnumList[_propertyFrequency] = (int)PREPARESETUP_FREQUENCY;
   _string2EnumList[_propertyChannel] = (int)PREPARESETUP_CHANNEL;
   _string2EnumList[_propertyStationsToBeReserved] = (int)PREPARESETUP_STATIONSTOBERESERVED;
   _string2EnumList[_propertySeperateAP] = (int)PREPARESETUP_SEPARATEAP;
   _string2EnumList[_propertyP2PConfig] = (int)PREPARESETUP_P2PCONFIG;
   _string2EnumList[_propertyGOIntent] = (int)PREPARESETUP_GOINTENT;
   
   _enum2StringList[(int)PREPARESETUP_MODE] = &_propertyMode;
   _enum2StringList[(int)PREPARESETUP_APCONFIG] = &_propertyAPConfig;
   _enum2StringList[(int)PREPARESETUP_TYPE] = &_propertyType;
   _enum2StringList[(int)PREPARESETUP_SSID] = &_propertySSID;
   _enum2StringList[(int)PREPARESETUP_SSID_VALUE] = &_propertySSIDValue;
   _enum2StringList[(int)PREPARESETUP_SSID_UTF8] = &_propertySSIDutf8;
   _enum2StringList[(int)PREPARESETUP_PASSPHRASE] = &_propertyPassphrase;
   _enum2StringList[(int)PREPARESETUP_SECURITY] = &_propertySecurity;
   _enum2StringList[(int)PREPARESETUP_VISIBILITY] = &_propertyVisibility;
   _enum2StringList[(int)PREPARESETUP_FREQUENCY] = &_propertyFrequency;
   _enum2StringList[(int)PREPARESETUP_CHANNEL] = &_propertyChannel;
   _enum2StringList[(int)PREPARESETUP_STATIONSTOBERESERVED] = &_propertyStationsToBeReserved;
   _enum2StringList[(int)PREPARESETUP_SEPARATEAP] = &_propertySeperateAP;
   _enum2StringList[(int)PREPARESETUP_P2PCONFIG] = &_propertyP2PConfig;
   _enum2StringList[(int)PREPARESETUP_GOINTENT] = &_propertyGOIntent;
}

ConflictManagementPrepareSetup::~ConflictManagementPrepareSetup()
{
}

PrepareSetupConfigurationName ConflictManagementPrepareSetup::getProperty2Enum(const ::std::string& value) const
{
   return (PrepareSetupConfigurationName)convertString2Enum(value);
}

const ::std::string& ConflictManagementPrepareSetup::getProperty2String(const PrepareSetupConfigurationName value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& ConflictManagementPrepareSetup::getProperty2StringTrace(const PrepareSetupConfigurationName value) const
{
   if(PREPARESETUP_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_emptyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //bosch
} //org

/** @} */
