/**
 * @file IConflictManagementService.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_CONFLICT_MANAGEMENT_SERVICE_H
#define _I_CONFLICT_MANAGEMENT_SERVICE_H


#include "WBLMessages.h"
#include "IWBLServiceResponse.h"

namespace org
{
namespace bosch
{

class IConflictManagementService:public IWBLServiceResponse
{
public:
   virtual ~IConflictManagementService(){}
   virtual void onWifiPriorityList(const PriorityList& msg) = 0;
   virtual void onChangeinConfigurationTimer(const uint16 &timer) = 0;
   virtual void onConflictDetected(const ConflictDetectedMsg& msg) = 0;
   virtual void onConflictResolved(const ConflictResolvedMsg& msg) = 0;
};

} //namespace bosch
} //namespace org

#endif //_I_CONFLICT_MANAGEMENT_SERVICE_H

/** @} */
