/**
 * @file ConflictManagementService.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CONFLICT_MGMT_SERVICE_H
#define _CONFLICT_MGMT_SERVICE_H

#include <cstdio>
#include <string>
#include <vector>
#include <map>

#include "asf/core/Logger.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusStubDelegate.h"

#include "org/bosch/wbl/conflictmanagementStub.h"

#include "IWBLServiceProperties.h"
#include "IConflictManagementService.h"
#include "WBLMessageTypes.h"
#include "WBLMessages.h"
#include "IWBLPriorityManager.h"


namespace org
{
namespace bosch
{

using namespace ::org::bosch::wbl::conflictmanagement;
using namespace ::asf::core;

class ConflictManagementService final:
      public ConflictmanagementStub,
      public IWBLServiceProperties,
      public IConflictManagementService
{
public:

   ConflictManagementService(::std::string portName);
   virtual ~ConflictManagementService();

   //! Interfaces of ConflictmanagementStub
   virtual void onDeActivateSetupRequest(const ::boost::shared_ptr< DeActivateSetupRequest >& request) override;
   virtual void onPrepareSetupRequest(const ::boost::shared_ptr< PrepareSetupRequest >& request) override;
   virtual void onWiFiStationModeUsageRequest(const ::boost::shared_ptr< WiFiStationModeUsageRequest >& request) override;
   virtual void onResolveConflictRequest(const ::boost::shared_ptr< ResolveConflictRequest >& request) override;
   virtual void onWiFiPriorityListSet(const ::boost::shared_ptr< WiFiPriorityListSet >& payload) override;
   virtual void onConfigurationTimerSet(const ::boost::shared_ptr< ConfigurationTimerSet >& payload) override;

   //! Interfaces of ConflictManagementServiceIf
   virtual void onWBLServiceResponse(const ::boost::shared_ptr< WBLBaseMsg > msg) override;
   virtual void onWifiPriorityList(const PriorityList &prioritylist) override;
   virtual void onChangeinConfigurationTimer(const uint16 &timer) override;
   virtual void onConflictDetected(const ConflictDetectedMsg& msg) override;
   virtual void onConflictResolved(const ConflictResolvedMsg& msg) override;

   //! Function to support ObjectManagerService
   virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& propertiesMap) override;
   virtual void getDBusObjectPath(::std::string& objPath) override;
   virtual void getInterfaceName(::std::string& interfaceName) override;
   void updateInterfaceAdded();
   void updateInterfaceRemoved();

   //! Interfaces of WBLServiceProperties
   virtual void onActiveWifiSetupsChanged(const ActiveWifiSetupsMsg& msg) override;

private:
   void onPrepareSetupResponse(WBLErrorCode errcode, uint32 actToken);
   void onDeactivateSetupResponse(WBLErrorCode errcode, uint32 actToken);
   void onResolveConflictResponse(WBLErrorCode errcode, uint32 actToken);
   void onWiFiStationModeUsageResponse(WBLErrorCode errcode, uint32 actToken);

   void printWifiSetUpInfo(const WifiSetUpItem& item) const;

   bool parseWifiMode(::std::map < ::std::string, ::asf::dbus::DBusVariant >& configurationMap, WifiMode &wifiMode);
   bool parseAPConfig(::std::map < ::std::string, ::asf::dbus::DBusVariant >& data,APConfig& property);
   bool parseActionType(::std::map < ::std::string, ::asf::dbus::DBusVariant >& configurationMap, WBLActionType &actionType)const;

   void bindWiFiSetup(::std::vector < ActiveWiFiSetupsStruct >& activeWifiSetups,const WifiSetUpItem& item);
   void insertAssociatedStation(const AssociatedStationItem &staItem, DBusMessageIter* iterSta);

   void insertRequestedAPConfigData(const APConfig &apConfig,DBusMessageIter* iterAPConfig);

   void insertConflictConfigs(::std::map<std::string, ::asf::dbus::DBusVariant>& conflictMap,
         const ConflictDetectedItem &Item);
   void insertConflictData(::std::map<std::string, ::asf::dbus::DBusVariant>& conflictMap,
         const ConflictDetectedItem &Item);
   void insertAPConfigElements(const APSetup &apSetup,
         ::std::map<::std::string, ::asf::dbus::DBusVariant> &setupsMap);
   void insertSupportedFrequencies(const APSetup &apSetup,
         ::std::map<::std::string, ::asf::dbus::DBusVariant> &setupsMap);
   void insertTechnologyRestrictions(::std::map<::std::string, ::asf::dbus::DBusVariant> &setupsMap);
   void insertIPv4Configuration(const APSetup &apSetup,
         ::std::map<::std::string, ::asf::dbus::DBusVariant> &setupsMap);

   void addRestrictionsListItem(DBusMessageIter *iterRestrict,::std::string tech,::std::string state);

   void addIpv4ConfigurationItem(DBusMessageIter *iterConfig,IPv4Configuration &ipconfig);

   void insertConnectionStatus(const WBLConnectionStatus &connectionStatus,
         ::std::map<::std::string, ::asf::dbus::DBusVariant> &setupsMap);

   void notifyActiveWiFiSetups(const ::std::vector< ActiveWiFiSetupsStruct >& activeWiFiSetups);
   void clearEmptyProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& propertiesList);

   DECLARE_CLASS_LOGGER();
};

} //namespace bosch
} //namespace org

#endif //_CONFLICT_MGMT_SERVICE_H

/** @} */
