/**
 * @file ConflictManagementPrepareSetup.h
 * @author RBEI/ECO32 Karthikeyan
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */


#ifndef _CONFLICT_MANAGEMENT_PREPARE_SETUP_H
#define _CONFLICT_MANAGEMENT_PREPARE_SETUP_H

#include <string>

#include "DbusProperties.h"
#include "ConflictManagementTypes.h"

namespace org
{
namespace bosch
{

/**
 * Service properties class for Connman interface.
 */
class ConflictManagementPrepareSetup : public DbusProperties
{
public:
   ConflictManagementPrepareSetup();
   virtual ~ConflictManagementPrepareSetup();

   PrepareSetupConfigurationName getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const PrepareSetupConfigurationName value) const;
   const ::std::string& getProperty2StringTrace(const PrepareSetupConfigurationName value) const;

private:

   const ::std::string _propertyMode;
   const ::std::string _propertyAPConfig;
   const ::std::string _propertyType;
   const ::std::string _propertySSID;
   const ::std::string _propertySSIDValue;
   const ::std::string _propertySSIDutf8;
   const ::std::string _propertyPassphrase;
   const ::std::string _propertySecurity;
   const ::std::string _propertyVisibility;
   const ::std::string _propertyFrequency;
   const ::std::string _propertyChannel;
   const ::std::string _propertyStationsToBeReserved;
   const ::std::string _propertySeperateAP;
   const ::std::string _propertyP2PConfig;
   const ::std::string _propertyGOIntent;
};

static ConflictManagementPrepareSetup sConfMngmtPrepareSetupProperties;

} //bosch
} //org

#endif //_CONNMAN_DBUS_TECHNOLOGY_PROPERTIES_H

/** @} */
