/**
 * @file WBLServiceInterfaces.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */


#ifndef _WBL_SERVICE_INTERFACES_H
#define _WBL_SERVICE_INTERFACES_H

#include <string>

#include "IDbusProperty2EnumMapping.h"
#include "ConflictManagementTypes.h"
#include "ConflictManagementPrepareSetup.h"

namespace org
{
namespace bosch
{

/**
 * Class for Wapdmgr DBUS interfaces.
 */
class WBLServiceInterfaces : public IDbusProperty2EnumMapping
{
public:
   WBLServiceInterfaces();
   virtual ~WBLServiceInterfaces();

   virtual void getInterfaces(::std::vector< const ::std::map< ::std::string, int >* >& interfaceList,
         const ::std::vector< int >& matchingInterfaces) const override;

   const ::std::string& getInterfaceName(const WBLInterface interface) const;

   inline PrepareSetupConfigurationName getPrepareSetupConfiguration2Enum(const ::std::string& value) const
   {
      return (PrepareSetupConfigurationName) (_prepareSetupProperties.convertString2Enum(value));
   }

   inline const ::std::string& getPrepareSetupConfiguration2String(const PrepareSetupConfigurationName value) const
   {
      return (_prepareSetupProperties.convertEnum2String((int) value));
   }

private:
   const ::std::string _dummy;
   const ::std::string _interfacePrepareSetup;

   ConflictManagementPrepareSetup _prepareSetupProperties;
};


} //bosch
} //org

#endif //_WBL_SERVICE_INTERFACES_H

/** @} */
