/**
 * @file WBLServiceFactory.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WBL_SERVICE_FACTORY_H
#define _WBL_SERVICE_FACTORY_H

#include "asf/core/Logger.h"

#include "WBLTypes.h"
#include "WBLPortsDefines.h"
#include "GenericSingleton.h"
#include "ObjectManagerService.h"
#include "ConflictManagementService.h"
#include "LastIntendedModeService.h"
#include "WifiSetupService.h"
#include "WifiSetupManager.h"
#include "DBManager.h"
#include "WBLPriorityManagerFactory.h"

namespace org
{
namespace bosch
{

using namespace ::asf::core;

class ObjectManagerService;
class ConflictManagementService;
class WifiSetupManager;
class LastIntendedModeService;
class cRegCountryCodeInfoIf;

class WBLServiceFactory final : public GenericSingleton<WBLServiceFactory>
{

public:
  ~WBLServiceFactory();
  WBLServiceFactory(const WBLServiceFactory& ref);
  WBLServiceFactory& operator=(const WBLServiceFactory& ref);
   
   ObjectManagerService* getObjectManagerServiceIf();
   ConflictManagementService* getConflictManagementServiceIf();
   LastIntendedModeService* getLastIntendedModeServiceIf();
   WifiSetupManager* getWifiSetupManager();
   cRegCountryCodeInfoIf *getRegCCInfoService();
   void createRegCCInfoService();
   void deleteRegCCInfoService();

   void notifyActiveWifiSetups(const ActiveWifiSetupsMsg& msg); 

private:
   friend class GenericSingleton<WBLServiceFactory>;
   WBLServiceFactory();

   ObjectManagerService* _poObjectManagerServiceIf;
   ConflictManagementService* _poConflictMgmtServiceIf;
   LastIntendedModeService*    _poLastIntendedModeServiceIf;
   WifiSetupManager* _poWifiSetupManager;
   cRegCountryCodeInfoIf *_regCountryCodeInfoSrvIf;
   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_WBL_SERVICE_FACTORY_H

/** @} */
