/**
 * @file WpaSupplicantProxyManager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPA_SUPPLICANT_PROXY_MANAGER_H
#define _WPA_SUPPLICANT_PROXY_MANAGER_H

#include "asf/core/Logger.h"
#include "ProxyManager.h"
#include "WpaSupplicantTypes.h"
#include "ProxyCallbacksManager.h"
#include "IWpaSupplicantProxyIf.h"

namespace org {
	namespace bosch {

class cWpaSupplicantProxyManager :
		public ::asf::core::ServiceAvailableIF,
		public cIWpaSupplicantProxyIf {

public:
	cWpaSupplicantProxyManager();
	virtual ~cWpaSupplicantProxyManager();
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) override;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") override;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIWpaSupplicantNotifCallbackIf *cb) override;
	virtual act_t sendGetInterfaceRequest(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cGetIfaceCbIf &cb, const ::std::string &iface) override;
	virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;

private:
	ProxyManager<cWpaSupplicantProxy> m_oProxyManager;
	ProxyCallbacksManager<cIWpaSupplicantNotifCallbackIf>  m_pProxyCbManager;
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_WPA_SUPPLICANT_PROXY_MANAGER_H

/** @} */
