/**
 * @file IWpaSupplicantIfaceNotifCallbackIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPASUPPLICANT_IFACE_NOTIF_CALLBACK_IF_H
#define _WPASUPPLICANT_IFACE_NOTIF_CALLBACK_IF_H

#include "WpaSupplicantTypes.h"

namespace org {
	namespace bosch {

class cIWpaSupplicantIfaceNotifCallbackIf:
		public cBssAddedCbIf,
		public cBssRemovedCbIf,
		public cWpaDisconnectCallbackIF {
public:
	cIWpaSupplicantIfaceNotifCallbackIf() {}
	virtual ~cIWpaSupplicantIfaceNotifCallbackIf() {}
	virtual void onWpaSupplicantIfaceServiceAvailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onWpaSupplicantIfaceServiceUnavailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onBSSAddedError(const ::boost::shared_ptr<cWpaSupplicantIfaceProxy> &proxy,
			const ::boost::shared_ptr<cBssAddedError> &error) override = 0;
	virtual void onBSSAddedSignal(const ::boost::shared_ptr<cWpaSupplicantIfaceProxy> &proxy,
			const ::boost::shared_ptr<cBssAddedSignal> &signal) override = 0;
	virtual void onBSSRemovedError(const ::boost::shared_ptr<cWpaSupplicantIfaceProxy> &proxy,
			const ::boost::shared_ptr<cBssRemovedError> &error) override = 0;
	virtual void onBSSRemovedSignal(const ::boost::shared_ptr<cWpaSupplicantIfaceProxy> &proxy,
			const ::boost::shared_ptr<cBssRemovedSignal> &signal) override = 0;
	virtual void onDisconnectError(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy >& proxy,
			const ::boost::shared_ptr< cWpaDisconnectError >& error) override = 0;
	virtual void onDisconnectResponse(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy >& proxy,
			const ::boost::shared_ptr< cWpaDisconnectResponse >& response) override = 0;
};

	}
}

#endif //_WPASUPPLICANT_IFACE_NOTIF_CALLBACK_IF_H
/** @} */
