/**
 * @file WapdmgrDbusAccessPointProperties.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */


#include "WBLDefines.h"
#include "WapdmgrDbusAccessPointProperties.h"

namespace org {
namespace bosch {


WapdmgrDbusAccessPointProperties::WapdmgrDbusAccessPointProperties() : DbusProperties("AccessPoint"),
   _propertyMacAddress("MacAddress"), 
   _propertyAPType("APType"),
   _propertySSID("SSID"),
   _propertyInterface("Interface"),
   _propertyPowerState("PowerState"),
   _propertyPowerFailure("PowerFailureReason"),
   _propertyPowered("Powered"),
   _propertySecurity("Security"), 
   _propertyPassphrase("Passphrase"),
   _propertySupportedChannels("SupportedChannels"),
   _propertyCurrentChannel("CurrentOperatingChannel"),
   _propertyMaxStationsAllowed("MaximumStationsAllowed"),
   _propertyVendorIEs("VendorIEs"),
   _propertyHidden("Hidden"),
   _propertyCountryCode("CountryCode"),
   _propertyAccessNetworkType("AccessNetworkType")
{
   _string2EnumList[_propertyMacAddress] = (int)AP_MAC_ADDRESS;
   _string2EnumList[_propertyAPType] = (int)AP_TYPE;
   _string2EnumList[_propertySSID] = (int)AP_SSID;
   _string2EnumList[_propertyInterface] = (int)AP_INTERFACE;
   _string2EnumList[_propertyPowerState] = (int)AP_POWERSTATE;
   _string2EnumList[_propertyPowerFailure] = (int)AP_POWERFAILURE;
   _string2EnumList[_propertyPowered] = (int)AP_POWERED;
   _string2EnumList[_propertySecurity] = (int)AP_SECURITY;
   _string2EnumList[_propertyPassphrase] = (int)AP_PASSPHRASE;
   _string2EnumList[_propertySupportedChannels] = (int)AP_SUPPORTED_CHANNELS;
   _string2EnumList[_propertyCurrentChannel] = (int)AP_CURRENT_CHANNEL;
   _string2EnumList[_propertyMaxStationsAllowed] = (int)AP_MAX_STA_ALLOWED;
   _string2EnumList[_propertyVendorIEs] = (int)AP_VENDOR_IE;
   _string2EnumList[_propertyHidden] = (int)AP_HIDDEN;
   _string2EnumList[_propertyCountryCode] = (int)AP_REG_DOM;
   _string2EnumList[_propertyAccessNetworkType] = (int)AP_ACCESS_NETWORK_TYPE;

   _enum2StringList[(int)AP_MAC_ADDRESS] = &_propertyMacAddress;
   _enum2StringList[(int)AP_TYPE] = &_propertyAPType;
   _enum2StringList[(int)AP_SSID] = &_propertySSID;
   _enum2StringList[(int)AP_INTERFACE] = &_propertyInterface;
   _enum2StringList[(int)AP_POWERSTATE] = &_propertyPowerState;
   _enum2StringList[(int)AP_POWERFAILURE] = &_propertyPowerFailure;
   _enum2StringList[(int)AP_POWERED] = &_propertyPowered;
   _enum2StringList[(int)AP_SECURITY] = &_propertySecurity;
   _enum2StringList[(int)AP_PASSPHRASE] = &_propertyPassphrase;
   _enum2StringList[(int)AP_SUPPORTED_CHANNELS] = &_propertySupportedChannels;
   _enum2StringList[(int)AP_CURRENT_CHANNEL] = &_propertyCurrentChannel;
   _enum2StringList[(int)AP_MAX_STA_ALLOWED] = &_propertyMaxStationsAllowed;
   _enum2StringList[(int)AP_VENDOR_IE] = &_propertyVendorIEs;
   _enum2StringList[(int)AP_HIDDEN] = &_propertyHidden;
   _enum2StringList[(int)AP_REG_DOM] = &_propertyCountryCode;
   _enum2StringList[(int)AP_ACCESS_NETWORK_TYPE] = &_propertyAccessNetworkType;
}

WapdmgrDbusAccessPointProperties::~WapdmgrDbusAccessPointProperties()
{
}

AccessPointPropertyName WapdmgrDbusAccessPointProperties::getProperty2Enum(
      const ::std::string& value) const
{
   return (AccessPointPropertyName)convertString2Enum(value);
}

const ::std::string& WapdmgrDbusAccessPointProperties::getProperty2String(
      const AccessPointPropertyName value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& WapdmgrDbusAccessPointProperties::getProperty2StringTrace(
      const AccessPointPropertyName value) const
{
   if(AP_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_emptyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //bosch
} //org

/** @} */
