/**
 * @file WapdmgrDbusAssociatedStationProperties.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _WAPDMGR_DBUS_ASSOCIATED_STATION_PROPERTIES_H
#define _WAPDMGR_DBUS_ASSOCIATED_STATION_PROPERTIES_H

#include <string>

#include "DbusProperties.h"
#include "WapdmgrDbusTypes.h"

namespace org 
{
namespace bosch 
{
/**
 * Service properties class for Wapdmgr interface.
 */
class WapdmgrDbusAssociatedStationProperties : public DbusProperties
{
public:
   WapdmgrDbusAssociatedStationProperties();

   virtual ~WapdmgrDbusAssociatedStationProperties();

   AssociatedStationPropertyName getProperty2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const AssociatedStationPropertyName value) const;

   const ::std::string& getProperty2StringTrace(const AssociatedStationPropertyName value) const;

private:
   const ::std::string _propertyMacAddress;
   const ::std::string _propertyAccesspointPath;
   const ::std::string _propertyInterface;
   const ::std::string _propertyIPAddress;
   const ::std::string _propertyHostname;

};

static WapdmgrDbusAssociatedStationProperties sWapdmgrDbusASProperties;

} //bosch
} //org

#endif //_WAPDMGR_DBUS_ASSOCIATED_STATION_PROPERTIES_H

/** @} */
