/**
 * @file WapdmgrAccessPointProxyManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _WAPDMGR_ACCESS_POINT_PROXY_MANAGER_H
#define _WAPDMGR_ACCESS_POINT_PROXY_MANAGER_H

#include <string>

#include "ProxyManager.h"
#include "ProxyCallbacksManager.h"
#include "IWapdmgrAccessPointProxyIf.h"

namespace org 
{
namespace bosch 
{
//forward declarations
class WapdmgrAccessPointProxyManager :
   public ::asf::core::ServiceAvailableIF,
   public IWapdmgrAccessPointProxyIf
{
   public:

      WapdmgrAccessPointProxyManager();

      virtual ~WapdmgrAccessPointProxyManager();

      // IWapdmgrAccessPointProxyIf implementation
      virtual void createProxy(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void createDHCPDNSConfigurationProxy(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void createTetheringSettingsProxy(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void destroyProxy() override;

      virtual bool isProxyServiceAvailable(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void setCallbackIf(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         ProxyUser user, IWapdmgrAccessPointNotifCallbackIf* callbackIf) override;

      virtual act_t sendSetSSIDRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrSetSSIDCbIf& callbackIf, const ::std::vector< uint8 >& ssid,
            bool utf_ssid) override;

      virtual act_t sendDeAuthenticateStationRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrDeAuthenticateStationCbIf& callbackIf, const ::std::string& macAddress) override;

      virtual act_t sendBlacklistStationRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrBlacklistStationCbIf& callbackIf, const ::std::string& macAddress,
            bool allow) override;

      virtual act_t sendSetOperatingChannelsRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrSetOperatingChannelsCbIf& callbackIf, const ::std::vector< uint16 >& channels) override;

      virtual act_t sendStartWPSPushButtonRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrStartWPSPushButtonCbIf& callbackIf) override;

      virtual act_t sendCancelWPSRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrCancelWPSCbIf& callbackIf) override;

      virtual act_t sendGetAssociatedStationsRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrGetAssociatedStationsCbIf& callbackIf) override;

      virtual act_t sendRegisterVendorServiceRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrRegisterVendorServiceCbIf& callbackIf, const ::std::vector< ::std::vector< uint8 > >& iEs) override;

      virtual act_t sendUnregisterVendorServiceRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrUnregisterVendorServiceCbIf& callbackIf, const ::std::vector< ::std::vector< uint8 > >& iEs) override;

      virtual act_t sendGetDnsDhcpConfRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrGetDnsDhcpConfCbIf& callbackIf) override;

      virtual act_t sendRestoreDefaultAPSettingsRequest(const ::std::string& busName,
            const ::std::string& objPath,const ::DBusBusType busType,
            WapdmgrRestoreDefaultAPSettingsCbIf& callbackIf) override;

      virtual bool sendPoweredSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPPoweredCbIf& callbackIf, bool powered) override;

      virtual bool sendHiddenSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPHiddenCbIf& callbackIf, bool hidden) override;

      virtual bool sendSecuritySet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPSecurityCbIf& callbackIf, const ::std::string& security) override;

      virtual bool sendPassphraseSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPPassphraseCbIf& callbackIf, const ::std::string& passphrase) override;

      virtual act_t sendSupportedChannelsGet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPSupportedChannelsCbIf& callbackIf) override;

      virtual act_t sendGetAllProperties(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPGetAllCallbackIf& callbackIf) override;

      virtual bool sendCountryCodeSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPCountryCodeCbIf& callbackIf, const ::std::string& country_code) override;

      virtual bool sendTetheringSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrTetheringCbIf& callbackIf, bool tethering) override;

      virtual bool sendMaxStationsAllowedSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAPMaxStationsAllowedCbIf& callbackIf, uint16 noOfStations) override;

      virtual bool sendAccessNetworkTypeSet(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            WapdmgrAccessNetworkTypeCallbackIF& callbackIf, uint16 networkType) override;

      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

      virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

   protected:

   private:

      void registerAccesspointProperties(::boost::shared_ptr<WapdmgrAccesspointProxy>& accessPointProxy,
            const ::asf::core::ServiceStateChange& stateChange);
      void registerTetheringSettings(::boost::shared_ptr<WapdmgrTetheringSettingsProxy>& proxyTethering,
            const ::asf::core::ServiceStateChange& stateChange);
      void registerDHCPProperties(::boost::shared_ptr<WapdmgrDHCPDNSConfigurationProxy>& proxyDHCP,
            const ::asf::core::ServiceStateChange& stateChange);

      ProxyManager< WapdmgrAccesspointProxy >                        _proxyAP;
      ProxyManager< WapdmgrAPPropertiesProxy >                       _proxyAPProperties;
      ProxyManager< WapdmgrDHCPDNSConfigurationProxy >               _proxyDHCPDNSConfiguration;
      ProxyManager< WapdmgrTetheringSettingsProxy>                   _proxyTetheringSettings;
      ProxyCallbacksManager< IWapdmgrAccessPointNotifCallbackIf >    _proxyCbManager;

      DECLARE_CLASS_LOGGER();
};


} // namespace bosch
} // namespace org

/** @} */

#endif //_WAPDMGR_ACCESS_POINT_PROXY_MANAGER_H

/** @} */
