/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     IWapdmgrAssociatedStationProxyIf.h
 *
 *\author   Ramya Murthy (RBEI/ECO21) <Ramya.Murthy2@in.bosch.com>
 *
 *\par Copyright:
 *(c) 2016 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef _I_WAPDMGR_ASSOCIATED_STATION_PROXY_IF_H
#define _I_WAPDMGR_ASSOCIATED_STATION_PROXY_IF_H

#include <string>

#include "ProxyTypes.h"
#include "WapdmgrAssociatedStationsTypes.h"
#include "IWapdmgrAssociatedStationsNotifCallbackIf.h"

namespace org
{
namespace bosch
{

// forward declarations

class IWapdmgrAssociatedStationProxyIf
{
public:

   virtual ~IWapdmgrAssociatedStationProxyIf() {}

   virtual void createProxy(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType) = 0;

   virtual void destroyProxy() = 0;

   virtual bool isProxyServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType) = 0;

   /**
    * Set callback handler.
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type (DBUS_BUS_SYSTEM or DBUS_BUS_SESSION)
    * @param[in] user: user
    * @param[in] callbackIf: callback handler
    */
   virtual void setCallbackIf(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         ProxyUser user, IWapdmgrAssociatedStationNotifCallbackIf* callbackIf) = 0;

   /**
    * Send method request to get all AssociatedStation properties
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type (DBUS_BUS_SYSTEM or DBUS_BUS_SESSION)
    */
   virtual void getAllProperties(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         IWapdmgrAssociatedStationNotifCallbackIf* callbackIf) = 0;

   //TODO - add interfaces if required
};

} // namespace bosch
} // namespace org

#endif //_I_WAPDMGR_ASSOCIATED_STATION_PROXY_IF_H

/** @} */

