/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     IWapdmgrAssociatedStationNotifCallbackIf.h
 *
 *\author   Ramya Murthy (RBEI/ECO21) <Ramya.Murthy2@in.bosch.com>
 *
 *\par Copyright:
 *(c) 2016 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef _I_WAPDMGR_ASSOCIATED_STATION_NOTIF_CB_IF_H
#define _I_WAPDMGR_ASSOCIATED_STATION_NOTIF_CB_IF_H

#include <string>

#include "WapdmgrAssociatedStationsTypes.h"

namespace org
{
namespace bosch
{

// forward declarations

class IWapdmgrAssociatedStationNotifCallbackIf:
   public WapdmgrASMacAddressCbIf,
   public WapdmgrASAccesspointCbIf,
   public WapdmgrASInterfaceCbIf,
   public WapdmgrASIPAddressCbIf,
   public WapdmgrASHostnameCbIf
{
   public:

   virtual ~IWapdmgrAssociatedStationNotifCallbackIf() {}

   virtual void onWapdmgrAssociatedStnServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;
   virtual void onWapdmgrAssociatedStnServiceUnavailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;

   virtual void onMacAddressError(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASMacAddressError >& error) override = 0;
   virtual void onMacAddressUpdate(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASMacAddressUpdate >& update) override = 0;
   virtual void onAccesspointError(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASAccesspointError >& error) override = 0;
   virtual void onAccesspointUpdate(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASAccesspointUpdate >& update) override = 0;
   virtual void onInterfaceError(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASInterfaceError >& error) override = 0;
   virtual void onInterfaceUpdate(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASInterfaceUpdate >& update) override = 0;
   virtual void onIPAddressError(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASIPAddressError >& error) override = 0;
   virtual void onIPAddressUpdate(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASIPAddressUpdate >& update) override = 0;
   virtual void onHostnameError(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASHostnameError >& error) override = 0;
   virtual void onHostnameUpdate(const ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrASHostnameUpdate >& update) override = 0;
};

} // namespace bosch
} // namespace org

#endif //_I_WAPDMGR_ASSOCIATED_STATION_NOTIF_CB_IF_H

/** @} */
