/**
 * @file LCMProxy.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 * @brief Interface to LCM Dbus Proxy for WBL
 *
 * @{
 */

#include "LCMProxy.h"
#include "LCMFactory.h"

namespace org
{
namespace bosch
{

DEFINE_CLASS_LOGGER_AND_LEVEL ("wifi_business_logic/WBLClients", LCMProxy, Info);

LCMProxy::LCMProxy():
      _regToken(0)
{
   LOG_INFO("LCMProxy:Constructor");
}

LCMProxy::~LCMProxy()
{
	// Commented the Log since it produces the Uncaught exception from Coverity
    // LOG_INFO("LCMProxy:Destructor");
}

void LCMProxy::createProxy(const std::string portName)
{
   LOG_INFO("LCMProxy:createProxy");
   _lcmDBusProxy = Lcm_dbus_fi_serviceProxy::createProxy(portName,*this);
}

void LCMProxy::destroyProxy()
{
   LOG_INFO("LCMProxy:destroyProxy");
   if (_lcmDBusProxy)
   {
      _lcmDBusProxy.reset();
   }

}

void LCMProxy::registerProperties(ILCMProxyCallbacks& callbackIf)
{
   LOG_INFO("LCMProxy:registerProperties");
   if(_lcmDBusProxy)
   {
      _regToken = _lcmDBusProxy->sendWifiStateRegister(callbackIf);
   }
}

void LCMProxy::deregisterProperties()
{
   LOG_INFO("LCMProxy:deregisterProperties");
   if(_lcmDBusProxy)
   {
      _lcmDBusProxy->sendWifiStateDeregister(_regToken);
   }
}

void LCMProxy::onAvailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
      const ::asf::core::ServiceStateChange& stateChange)
{
   (void)stateChange;
   if(proxy == _lcmDBusProxy)
   {
      LOG_INFO("LCMProxy:onAvailable for _lcmDBusProxy");
      LCMFactory* polcmFactory = LCMFactory::getInstance();
      ILCMClient* polcmClient = (polcmFactory) ? (polcmFactory->getLCMClientIf()) : (nullptr);
      if(polcmClient)
      {
         polcmClient->onLCMProxyAvailable();
      }
   }

} //LCMProxy::onAvailable

void LCMProxy::onUnavailable(const boost::shared_ptr<::asf::core::Proxy>& proxy,
      const ::asf::core::ServiceStateChange& stateChange)
{
   (void) stateChange;
   if (proxy == _lcmDBusProxy)
   {
      LOG_INFO("LCMProxy:onUnavailable for _lcmDBusProxy");
      LCMFactory* polcmFactory = LCMFactory::getInstance();
      ILCMClient* polcmClient = (polcmFactory) ? (polcmFactory->getLCMClientIf()) : (nullptr);
      if (polcmClient)
      {
         polcmClient->onLCMProxyUnavailable();
      }

   }

} //LCMProxy::onUnavailable

act_t LCMProxy::getWiFiState(ILCMProxyCallbacks& callbackIf)
{
   if (_lcmDBusProxy)
   {
      return _lcmDBusProxy->sendWifiStateGet(callbackIf);
   }
   return DEFAULT_ACT;

} //LCMProxy::getWiFiState


} //namespace bosch
} //namespace org

/** @} */
