/**
 * @file LCMProxy.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 * @brief LCM Dbus Proxy for WBL
 *
 * @{
 */

#ifndef _LCM_PROXY_H
#define _LCM_PROXY_H

#include "ILCMProxy.h"
#include "asf/core/Logger.h"

namespace org
{
namespace bosch
{

using namespace ::asf::core;
class LCMProxy : public ServiceAvailableIF, public ILCMProxy
{

public:
   LCMProxy();
   virtual ~LCMProxy();

   virtual void createProxy(const std::string portName) override;
   virtual void destroyProxy() override;
   virtual void registerProperties(ILCMProxyCallbacks& callbackIf) override;
   virtual void deregisterProperties() override;

   virtual void onAvailable(const boost::shared_ptr<::asf::core::Proxy>& proxy,
         const ::asf::core::ServiceStateChange& stateChange) override;
   virtual void onUnavailable(const boost::shared_ptr<::asf::core::Proxy>& proxy,
         const ::asf::core::ServiceStateChange& stateChange) override;

   virtual act_t getWiFiState(ILCMProxyCallbacks& callbackIf) override;

private:
   act_t _regToken;
   LCMDBusProxy _lcmDBusProxy;
   DECLARE_CLASS_LOGGER();
};

} //namespace bosch
} //namespace org

#endif //_LCM_PROXY_H

/** @} */
